<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $titulo = $_POST['titulo'];
    $contenido = $_POST['contenido'];
    $precio = $_POST['precio'];
    $link = $_POST['link'];

    $uploads_dir = 'publicaciones';
    if (!is_dir($uploads_dir)) {
        mkdir($uploads_dir, 0777, true);
    }

    // Manejo de imagen
    if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] === UPLOAD_ERR_OK) {
        $nombre_imagen = time() . '_' . basename($_FILES['imagen']['name']);
        $ruta_imagen = $uploads_dir . '/' . $nombre_imagen;
        move_uploaded_file($_FILES['imagen']['tmp_name'], $ruta_imagen);
    } else {
        $nombre_imagen = '';
    }

    // Generar datos
    $publicacion = array(
        'titulo' => $titulo,
        'contenido' => $contenido,
        'precio' => $precio,
        'link' => $link,
        'imagen' => $nombre_imagen,
        'fecha' => date('Y-m-d H:i:s')
    );

    // Guardar como JSON único
    $nombre_archivo = $uploads_dir . '/' . time() . '.json';
    file_put_contents($nombre_archivo, json_encode($publicacion, JSON_PRETTY_PRINT));
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="refresh" content="2;url=formulario.html">
        <title>Guardado con éxito</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background-color: #f8f9fa;
                display: flex;
                align-items: center;
                justify-content: center;
                height: 100vh;
                margin: 0;
            }
            .mensaje {
                background: #d4edda;
                border: 1px solid #c3e6cb;
                color: #155724;
                padding: 20px 30px;
                border-radius: 8px;
                font-size: 1.2rem;
                box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            }
        </style>
    </head>
    <body>
        <div class="mensaje">
            ✅ Publicación guardada con éxito. Redirigiendo...
        </div>
    </body>
    </html>
    <?php
    exit;
}
?>
