<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar publicaciones</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --accent-color: #4895ef;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4cc9f0;
            --danger-color: #f72585;
            --warning-color: #ffbe0b;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
            font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
            min-height: 100vh;
        }
        
        .navbar {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color)) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .navbar-brand {
            font-weight: 700;
            letter-spacing: 0.5px;
        }
        
        .nav-link {
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover, .nav-link.active {
            background-color: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
        }
        
        .container {
            max-width: 1200px;
        }
        
        h2 {
            color: var(--dark-color);
            font-weight: 700;
            position: relative;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        
        h2:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(to right, var(--primary-color), var(--accent-color));
            border-radius: 2px;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            background-color: white;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 14px 28px rgba(0, 0, 0, 0.1), 0 10px 10px rgba(0, 0, 0, 0.05);
        }
        
        .card-img {
            height: 200px;
            object-fit: cover;
            border-radius: 8px;
            margin-bottom: 1rem;
            transition: transform 0.3s ease;
        }
        
        .card:hover .card-img {
            transform: scale(1.02);
        }
        
        .form-control, .form-select {
            border-radius: 8px;
            padding: 0.75rem 1rem;
            border: 1px solid #e0e0e0;
            transition: all 0.3s ease;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--accent-color);
            box-shadow: 0 0 0 0.25rem rgba(72, 149, 239, 0.25);
        }
        
        label {
            font-weight: 600;
            color: var(--dark-color);
            margin-bottom: 0.5rem;
        }
        
        .btn-save {
            background: linear-gradient(to right, var(--primary-color), var(--accent-color));
            border: none;
            font-weight: 600;
            padding: 0.75rem 1.5rem;
            transition: all 0.3s ease;
        }
        
        .btn-save:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(67, 97, 238, 0.3);
        }
        
        .btn-delete {
            background: linear-gradient(to right, var(--danger-color), #ff4d6d);
            border: none;
            font-weight: 600;
            padding: 0.75rem 1.5rem;
            transition: all 0.3s ease;
        }
        
        .btn-delete:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(247, 37, 133, 0.3);
        }
        
        .alert {
            border-radius: 8px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        
        .alert-success {
            background: linear-gradient(to right, #38b000, #70e000);
            color: white;
        }
        
        .alert-danger {
            background: linear-gradient(to right, var(--danger-color), #ff4d6d);
            color: white;
        }
        
        .file-upload {
            position: relative;
            overflow: hidden;
            border: 2px dashed #e0e0e0;
            border-radius: 8px;
            padding: 2rem;
            text-align: center;
            transition: all 0.3s ease;
        }
        
        .file-upload:hover {
            border-color: var(--accent-color);
            background-color: rgba(72, 149, 239, 0.05);
        }
        
        .file-upload input[type="file"] {
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            cursor: pointer;
        }
        
        .file-upload-label {
            display: flex;
            flex-direction: column;
            align-items: center;
            color: #6c757d;
        }
        
        .file-upload-label i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
            color: var(--accent-color);
        }
        
        /* Animation */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .card {
            animation: fadeIn 0.5s ease forwards;
            opacity: 0;
        }
        
        .card:nth-child(1) { animation-delay: 0.1s; }
        .card:nth-child(2) { animation-delay: 0.2s; }
        .card:nth-child(3) { animation-delay: 0.3s; }
        .card:nth-child(4) { animation-delay: 0.4s; }
        .card:nth-child(5) { animation-delay: 0.5s; }
        .card:nth-child(6) { animation-delay: 0.6s; }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .card-img {
                height: 150px;
            }
            
            h2 {
                font-size: 1.8rem;
            }
        }
    </style>
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark sticky-top">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php">
        <i class="fas fa-cog me-2"></i>Panel de Administración
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarContent">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarContent">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="formulario.html"><i class="fas fa-plus-circle me-1"></i> Cargar</a></li>
        <li class="nav-item"><a class="nav-link" href="ver_publicaciones.php"><i class="fas fa-eye me-1"></i> Ver</a></li>
        <li class="nav-item"><a class="nav-link active" href="ver_gestion.php"><i class="fas fa-edit me-1"></i> Administrar</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container py-5">
    <h2 class="mb-4 text-center">Gestión de Publicaciones</h2>
    
    <?php
    $dir = 'publicaciones';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['archivo'])) {
        $archivo = $dir . '/' . basename($_POST['archivo']);
        if (isset($_POST['eliminar']) && $_POST['eliminar'] == '1') {
            if (file_exists($archivo)) unlink($archivo);
            echo '<div class="alert alert-danger mb-4"><i class="fas fa-trash-alt me-2"></i> Publicación eliminada correctamente.</div>';
        } else {
            $data = json_decode(file_get_contents($archivo), true);
            $data['titulo'] = $_POST['titulo'];
            $data['contenido'] = $_POST['contenido'];
            $data['precio'] = $_POST['precio'];
            $data['link'] = $_POST['link'];
            if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] === UPLOAD_ERR_OK) {
                $nombre_imagen = time() . '_' . basename($_FILES['imagen']['name']);
                move_uploaded_file($_FILES['imagen']['tmp_name'], $dir . '/' . $nombre_imagen);
                $data['imagen'] = $nombre_imagen;
            }
            file_put_contents($archivo, json_encode($data, JSON_PRETTY_PRINT));
            echo '<div class="alert alert-success mb-4"><i class="fas fa-check-circle me-2"></i> Publicación actualizada correctamente.</div>';
        }
    }

    if (is_dir($dir)) {
        foreach (glob($dir . '/*.json') as $archivo) {
            $nombre = basename($archivo);
            $data = json_decode(file_get_contents($archivo), true);
            if (!$data) continue;
            $titulo = htmlspecialchars($data['titulo']);
            $contenido = htmlspecialchars($data['contenido']);
            $precio = htmlspecialchars($data['precio']);
            $link = htmlspecialchars($data['link']);
            $imagen = $data['imagen'];
    ?>
    
    <div class="col">
        <div class="card p-4">
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="archivo" value="<?= $nombre ?>">
                
                <div class="row">
                    <div class="col-md-4 mb-3 mb-md-0">
                        <?php if (!empty($imagen) && file_exists("$dir/$imagen")): ?>
                            <img src="<?= "$dir/$imagen" ?>" class="card-img w-100" alt="<?= $titulo ?>">
                        <?php else: ?>
                            <div class="file-upload">
                                <label class="file-upload-label">
                                    <i class="fas fa-image"></i>
                                    <span>No hay imagen</span>
                                </label>
                                <input type="file" name="imagen">
                            </div>
                        <?php endif; ?>
                        
                        <div class="file-upload mt-3">
                            <label class="file-upload-label">
                                <i class="fas fa-camera"></i>
                                <span>Cambiar imagen</span>
                            </label>
                            <input type="file" name="imagen">
                        </div>
                    </div>
                    
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label class="form-label">Título</label>
                            <input type="text" class="form-control" name="titulo" value="<?= $titulo ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Descripción</label>
                            <textarea class="form-control" name="contenido" rows="4" required><?= $contenido ?></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Precio</label>
                                <div class="input-group">
                                    <span class="input-group-text">$</span>
                                    <input type="number" step="0.01" class="form-control" name="precio" value="<?= $precio ?>" required>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Link de compra</label>
                                <input type="url" class="form-control" name="link" value="<?= $link ?>" placeholder="https://...">
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-between mt-4">
                            <button type="submit" class="btn btn-save">
                                <i class="fas fa-save me-2"></i>Guardar cambios
                            </button>
                            
                            <button type="submit" name="eliminar" value="1" class="btn btn-delete" onclick="return confirm('¿Estás seguro de que deseas eliminar esta publicación? Esta acción no se puede deshacer.')">
                                <i class="fas fa-trash-alt me-2"></i>Eliminar
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <?php
        }
    }
    ?>
</div>

<footer class="bg-dark text-white py-4 mt-5">
    <div class="container text-center">
        <p class="mb-2">© 2023 Panel de Administración. Todos los derechos reservados.</p>
        <div class="social-icons">
            <a href="https://netfan.host" class="text-white mx-2"><i class="fas fa-question-circle"></i> Ayuda</a>
            <a href="https://netfan.host" class="text-white mx-2"><i class="fas fa-envelope"></i> Soporte</a>
            <div class="col-md-6 text-center text-md-end">
              <small class="text-white-50">Diseño y desarrollo por <a href="https://netfan.host" class="text-white">NETFAN</a></small>
            </div>
          </div>
        </div>
      </footer>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Efecto de carga suave
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            document.body.classList.add('loaded');
        }, 300);
        
        // Mostrar nombre de archivo al seleccionar imagen
        document.querySelectorAll('input[type="file"]').forEach(input => {
            input.addEventListener('change', function(e) {
                const fileName = e.target.files[0]?.name || 'Ningún archivo seleccionado';
                const label = this.closest('.file-upload').querySelector('span');
                label.textContent = fileName;
            });
        });
    });
    
    // Confirmación mejorada para eliminar
    document.querySelectorAll('[name="eliminar"]').forEach(btn => {
        btn.addEventListener('click', function(e) {
            if (!confirm('⚠️ ATENCIÓN: Esta acción eliminará permanentemente la publicación.\n\n¿Estás seguro de que deseas continuar?')) {
                e.preventDefault();
            }
        });
    });
</script>
</body>
</html>