<?php
require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// Filtros
$filtro_fecha = $_GET['fecha'] ?? date('Y-m-d');
$filtro_pago = $_GET['forma_pago'] ?? '';
$filtro_cliente = $_GET['cliente'] ?? '';

$where = "WHERE fecha = '$filtro_fecha'";
if ($filtro_pago) {
  $where .= " AND forma_pago = '" . mysqli_real_escape_string($con, $filtro_pago) . "'";
}
if ($filtro_cliente) {
  $where .= " AND cliente LIKE '%" . mysqli_real_escape_string($con, $filtro_cliente) . "%'";
}

$result = mysqli_query($con, "SELECT * FROM caja_mesa $where ORDER BY hora DESC");
$registros = mysqli_fetch_all($result, MYSQLI_ASSOC);

$totales = ['efectivo' => 0, 'transferencia' => 0, 'total' => 0];
foreach ($registros as $r) {
  $totales['efectivo'] += $r['efectivo'];
  $totales['transferencia'] += $r['transferencia'];
  $totales['total'] += $r['monto_total'];
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Admin Caja Mesas</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
  <h2>🧾 Administración Caja Mesas</h2>

  <form method="get" class="row g-2 mb-4">
    <div class="col-md-3">
      <label>📅 Fecha</label>
      <input type="date" name="fecha" class="form-control" value="<?= htmlspecialchars($filtro_fecha) ?>">
    </div>
    <div class="col-md-3">
      <label>💳 Forma de Pago</label>
      <select name="forma_pago" class="form-select">
        <option value="">-- Todas --</option>
        <option value="efectivo" <?= $filtro_pago === 'efectivo' ? 'selected' : '' ?>>Efectivo</option>
        <option value="transferencia" <?= $filtro_pago === 'transferencia' ? 'selected' : '' ?>>Transferencia</option>
        <option value="dividido" <?= $filtro_pago === 'dividido' ? 'selected' : '' ?>>Dividido</option>
      </select>
    </div>
    <div class="col-md-3">
      <label>🧍 Cliente</label>
      <input type="text" name="cliente" class="form-control" value="<?= htmlspecialchars($filtro_cliente) ?>">
    </div>
    <div class="col-md-3 align-self-end">
      <button class="btn btn-primary">🔍 Filtrar</button>
      <a href="admin_caja_mesas.php" class="btn btn-secondary">🔄 Limpiar</a>
    </div>
  </form>

  <div class="mb-3">
    <h5>💰 Totales:</h5>
    <p>Efectivo: <strong>$<?= number_format($totales['efectivo'], 2) ?></strong></p>
    <p>Transferencia: <strong>$<?= number_format($totales['transferencia'], 2) ?></strong></p>
    <p>Total general: <strong>$<?= number_format($totales['total'], 2) ?></strong></p>
  </div>

  <table class="table table-bordered table-striped">
    <thead>
      <tr>
        <th>#</th>
        <th>Mesa</th>
        <th>Cliente</th>
        <th>Comentario</th>
        <th>💰 Total</th>
        <th>💵 Efectivo</th>
        <th>💳 Transferencia</th>
        <th>🕒 Hora</th>
        <th>🔍 Ticket</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($registros as $r): ?>
      <tr>
        <td><?= $r['id'] ?></td>
        <td><?= $r['mesa_id'] ?></td>
        <td><?= htmlspecialchars($r['cliente']) ?></td>
        <td><?= htmlspecialchars($r['comentario']) ?></td>
        <td>$<?= number_format($r['monto_total'], 2) ?></td>
        <td>$<?= number_format($r['efectivo'], 2) ?></td>
        <td>$<?= number_format($r['transferencia'], 2) ?></td>
        <td><?= $r['hora'] ?></td>
        <td><a href="ver_ticket_mesa.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-outline-primary" target="_blank">Ver</a></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <form method="post" onsubmit="return confirm('¿Seguro que querés reiniciar toda la caja de mesas?');">
    <input type="hidden" name="reiniciar" value="1">
    <button type="submit" class="btn btn-danger mt-3">🗑 Reiniciar caja mesas</button>
  </form>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reiniciar'])) {
  mysqli_query($con, "DELETE FROM caja_mesa");
  echo "<script>alert('Caja de mesas reiniciada'); location.href='admin_caja_mesas.php';</script>";
}
?>

</body>
</html>
