<?php
require_once '../conexion.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$ids = $input['ids'] ?? [];

if (!is_array($ids) || count($ids) === 0) {
  echo json_encode(['ok' => false, 'msg' => 'Lista vacía']);
  exit;
}

$mesa_id = 1;
$agrupados = [];

foreach ($ids as $id) {
  $id = intval($id);
  $res = mysqli_query($con, "SELECT nombre FROM productos_mesas WHERE id = $id");
  if ($row = mysqli_fetch_assoc($res)) {
    $nombre = $row['nombre'];
    if (!isset($agrupados[$nombre])) {
      $agrupados[$nombre] = 0;
    }
    $agrupados[$nombre]++;
  }
}

$productos = [];
foreach ($agrupados as $nombre => $cantidad) {
  $productos[] = [
    'nombre' => $nombre,
    'cantidad' => $cantidad
  ];
}

$detalle_json = mysqli_real_escape_string($con, json_encode($productos, JSON_UNESCAPED_UNICODE));

mysqli_query($con, "
  INSERT INTO comandas_cocina (mesa_id, detalle, estado, hora)
  VALUES ($mesa_id, '$detalle_json', 0, NOW())
");

echo json_encode(['ok' => true]);
