<?php
require_once 'conexion.php';
header('Content-Type: application/json');

try {
    $query = "SELECT id, mesa_id, detalle, estado, hora 
              FROM comandas_cocina 
              WHERE estado IN (0,1) 
              ORDER BY hora ASC";
    
    $result = mysqli_query($con, $query);
    
    if (!$result) {
        throw new Exception('Error en la consulta: ' . mysqli_error($con));
    }
    
    $comandas = [];
    
    while ($row = mysqli_fetch_assoc($result)) {
        $detalle = json_decode($row['detalle'], true);
        
        // Validar y limpiar los datos del detalle
        if (!is_array($detalle)) {
            $detalle = [];
        } else {
            $detalle = array_map(function($item) {
                return [
                    'cantidad' => isset($item['cantidad']) ? (int)$item['cantidad'] : 1,
                    'nombre' => isset($item['nombre']) ? htmlspecialchars($item['nombre']) : 'Producto no especificado',
                    'notas' => isset($item['notas']) ? htmlspecialchars($item['notas']) : ''
                ];
            }, $detalle);
        }
        
        $comandas[] = [
            'id' => (int)$row['id'],
            'mesa_id' => (int)$row['mesa_id'],
            'hora' => date('H:i', strtotime($row['hora'])),
            'detalle' => $detalle,
            'estado' => (int)$row['estado']
        ];
    }
    
    echo json_encode($comandas);
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>