<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../restringir.php';
require '../conexion.php';

// Verificamos que sea admin
if ($_SESSION['nivel'] !== 'admin') {
  echo "Acceso denegado.";
  exit;
}

// Procesar formulario
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $usuario = $_POST['usuario'];
  $clave   = md5($_POST['clave']); // Cambiar a password_hash si se desea más adelante
  $nivel   = $_POST['nivel'];

  // Evitar duplicados
  $check = mysqli_query($con, "SELECT * FROM usuarios WHERE usuario = '$usuario'");
  if (mysqli_num_rows($check) > 0) {
    $msg = "⚠️ El usuario ya existe.";
  } else {
    mysqli_query($con, "INSERT INTO usuarios (usuario, clave, nivel) VALUES ('$usuario', '$clave', '$nivel')");
    $msg = "✅ Usuario creado correctamente.";
  }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Crear usuario</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-white">
  <div class="container mt-5">
    <h2>Crear nuevo usuario</h2>

    <?php if ($msg): ?>
      <div class="alert alert-info"><?= $msg ?></div>
    <?php endif; ?>

    <form method="post">
      <div class="mb-3">
        <label class="form-label">Usuario</label>
        <input type="text" name="usuario" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Contraseña</label>
        <input type="password" name="clave" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Nivel</label>
        <select name="nivel" class="form-select" required>
          <option value="usuario">Usuario</option>
          <option value="admin">Administrador</option>
        </select>
      </div>
      <button type="submit" class="btn btn-primary">Crear usuario</button>
    </form>

    <div class="mt-3">
      <a href="../dashboard.php" class="btn btn-secondary">← Volver al dashboard</a>
    </div>
  </div>
</body>
</html>
