<?php
/**
 * guardar_movimiento_manual_mesa.php
 * ----------------------------------
 * Inserta un ingreso / egreso manual en la caja de MESAS.
 * Espera (POST):
 *   - tipo        : 'ingreso' | 'egreso'
 *   - monto       : float > 0
 *   - forma_pago  : 'efectivo' | 'transferencia'
 *   - comentario  : texto (opcional)
 *   - mesa_id     : int (opcional, default 0). Útil si querés asociar el movimiento a una mesa concreta.
 *
 * Redirige a admin/caja_mesas.php al finalizar.
 */

ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// ----------- Sanitizar ----------
$accion      = $_POST['tipo']        ?? '';             // ingreso / egreso
$monto       = floatval($_POST['monto'] ?? 0);
$forma_pago  = $_POST['forma_pago']  ?? 'efectivo';     // efectivo / transferencia
$comentario  = trim($_POST['comentario'] ?? '');
$mesa_id     = intval($_POST['mesa_id'] ?? 0);

// Validaciones
if (!in_array($accion, ['ingreso', 'egreso'], true) || $monto <= 0) {
    die('❌ Datos inválidos.');
}
if (!in_array($forma_pago, ['efectivo', 'transferencia'], true)) {
    die('❌ Forma de pago inválida.');
}

// Si es egreso => monto negativo
if ($accion === 'egreso') {
    $monto = -abs($monto);
}

// Distribuir según forma de pago
$efectivo      = ($forma_pago === 'efectivo')      ? $monto : 0;
$transferencia = ($forma_pago === 'transferencia') ? $monto : 0;

// Fecha / hora actuales
$fecha = date('Y-m-d');
$hora  = date('H:i:s');

// Cliente pseudo (para identificar que es manual)
$cliente = 'Movimiento manual';

// ---------- Insertar ----------
$sql = "
    INSERT INTO caja_mesa
        (mesa_id, fecha, hora, monto_total, efectivo, transferencia, forma_pago, cliente, comentario)
    VALUES (?,?,?,?,?,?,?,?,?);
";

$stmt = $con->prepare($sql);
if (!$stmt) {
    die('❌ Error prepare: ' . $con->error);
}

$stmt->bind_param(
    'issdddsss',
    $mesa_id,
    $fecha,
    $hora,
    $monto,          // monto_total
    $efectivo,
    $transferencia,
    $forma_pago,
    $cliente,
    $comentario
);

if (!$stmt->execute()) {
    die('❌ Error execute: ' . $stmt->error);
}
$stmt->close();

// ---------- Volver a la vista ----------
header('Location: caja_mesas.php');
exit;
?>
