<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>BAR</title>
  <link rel="icon" href="https://nodo25.netfan.host/humclubdemusica/files/icon.png" type="image/png" />
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&family=Orbitron:wght@500&family=Press+Start+2P&display=swap" rel="stylesheet"/>
  <style>
    :root {
      --primary-color: #ff00c1;
      --secondary-color: #00f0ff;
      --accent-color: #ff3e9d;
      --text-color: #ffffff;
      --dark-bg: #0f0f1a;
      --neon-glow: 0 0 10px var(--primary-color), 
                  0 0 20px var(--secondary-color),
                  0 0 30px rgba(255, 62, 157, 0.5);
    }

    html, body {
      margin: 0;
      padding: 0;
      height: 100%;
      background: linear-gradient(135deg, #0f0c29 0%, #1a1a3e 50%, #24243e 100%);
      font-family: 'Montserrat', sans-serif;
      display: flex;
      justify-content: center;
      align-items: center;
      flex-direction: column;
      color: var(--text-color);
      overflow-x: hidden;
      position: relative;
    }

    body::before {
      content: '';
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        linear-gradient(rgba(255, 0, 193, 0.1) 1px, transparent 1px),
        linear-gradient(90deg, rgba(255, 0, 193, 0.1) 1px, transparent 1px);
      background-size: 20px 20px;
      z-index: -1;
      opacity: 0.5;
    }

    body.fade-in {
      animation: fadeIn 1s ease-out forwards;
    }

    body.fade-out {
      animation: fadeOut 1s ease-out forwards;
    }

    @keyframes fadeIn {
      from { opacity: 0; }
      to { opacity: 1; }
    }

    @keyframes fadeOut {
      from { opacity: 1; }
      to { opacity: 0; }
    }

    .title {
      font-family: 'Press Start 2P', 'Orbitron', sans-serif;
      font-size: 2.5rem;
      margin-bottom: 1.5rem;
      text-transform: uppercase;
      letter-spacing: 3px;
      color: var(--text-color);
      text-shadow: var(--neon-glow);
      position: relative;
      padding: 15px;
      border: 2px solid var(--secondary-color);
      box-shadow: inset 0 0 15px var(--primary-color), 0 0 15px var(--secondary-color);
      background: rgba(15, 15, 26, 0.7);
    }

    .title::after {
      content: '▼';
      position: absolute;
      bottom: -25px;
      left: 50%;
      transform: translateX(-50%);
      color: var(--secondary-color);
      font-size: 1rem;
      animation: bounce 2s infinite;
    }

    @keyframes bounce {
      0%, 20%, 50%, 80%, 100% {transform: translateY(0) translateX(-50%);}
      40% {transform: translateY(-10px) translateX(-50%);}
      60% {transform: translateY(-5px) translateX(-50%);}
    }

    .video-container {
      position: relative;
      max-width: 90%;
      max-height: 70vh;
      border-radius: 5px;
      overflow: hidden;
      box-shadow: 0 0 30px rgba(106, 17, 203, 0.5);
      margin-bottom: 2rem;
      border: 1px solid var(--primary-color);
      transition: all 0.5s ease;
    }

    .video-container:hover {
      box-shadow: 0 0 50px rgba(255, 0, 193, 0.7);
      transform: scale(1.01);
    }

    .video-container.fade-out {
      opacity: 0;
      transform: scale(0.9);
    }

    video {
      max-width: 100%;
      max-height: 100%;
      display: block;
      filter: hue-rotate(0deg) saturate(1.2);
      transition: filter 0.5s ease;
    }

    .video-container:hover video {
      filter: hue-rotate(10deg) saturate(1.5);
    }

    .buttons-container {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      gap: 20px;
      margin-top: 20px;
      perspective: 1000px;
    }

    .boton {
      padding: 14px 30px;
      font-size: 1rem;
      font-weight: 600;
      color: white;
      background: linear-gradient(45deg, var(--primary-color) 0%, var(--secondary-color) 100%);
      border: none;
      border-radius: 0;
      cursor: pointer;
      text-decoration: none;
      transition: all 0.4s ease;
      box-shadow: 0 4px 15px rgba(37, 117, 252, 0.3);
      min-width: 200px;
      text-align: center;
      position: relative;
      overflow: hidden;
      font-family: 'Orbitron', sans-serif;
      letter-spacing: 1px;
      text-transform: uppercase;
      clip-path: polygon(10% 0%, 90% 0%, 100% 50%, 90% 100%, 10% 100%, 0% 50%);
    }

    .boton:hover {
      transform: translateY(-3px) rotateX(15deg);
      box-shadow: 0 10px 25px rgba(255, 0, 193, 0.6);
      text-shadow: 0 0 5px white;
    }

    .boton:active {
      transform: translateY(1px);
    }

    .boton::before {
      content: '';
      position: absolute;
      top: -50%;
      left: -50%;
      width: 200%;
      height: 200%;
      background: linear-gradient(
        to bottom right,
        transparent 45%,
        rgba(255, 255, 255, 0.3) 50%,
        transparent 55%
      );
      transform: rotate(30deg);
      transition: all 0.5s ease;
    }

    .boton:hover::before {
      left: 100%;
    }

    /* Overlay vaporwave/post-punk mejorado */
    #redirect-overlay {
      position: fixed;
      top: 0; 
      left: 0;
      width: 100%; 
      height: 100%;
      background: rgba(15, 15, 26, 0.85); /* Más transparente */
      backdrop-filter: blur(5px); /* Efecto de desenfoque */
      color: white;
      display: none;
      justify-content: center;
      align-items: center;
      font-size: 1.5rem;
      z-index: 9999;
      text-align: center;
      padding: 20px;
      opacity: 0;
      transition: opacity 0.8s ease;
      flex-direction: column;
      font-family: 'Press Start 2P', cursive;
    }

    #redirect-overlay.active {
      display: flex;
      opacity: 1;
    }

    #redirect-overlay::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        linear-gradient(rgba(255, 0, 193, 0.1) 1px, transparent 1px),
        linear-gradient(90deg, rgba(255, 0, 193, 0.1) 1px, transparent 1px);
      background-size: 20px 20px;
      opacity: 0.5;
    }

    .redirect-content {
      position: relative;
      z-index: 2;
      text-align: center;
      width: 80%;
      max-width: 500px;
    }

    .redirect-text {
      margin-bottom: 30px;
      text-shadow: 0 0 10px var(--secondary-color);
      font-size: 1.2rem;
      position: relative;
    }

    .redirect-text span {
      color: var(--secondary-color);
      animation: glitch 1s linear infinite;
    }

    @keyframes glitch {
      0% {
        text-shadow: 0.05em 0 0 var(--primary-color), -0.05em -0.025em 0 var(--secondary-color);
      }
      14% {
        text-shadow: 0.05em 0 0 var(--primary-color), -0.05em -0.025em 0 var(--secondary-color);
      }
      15% {
        text-shadow: -0.05em -0.025em 0 var(--primary-color), 0.025em 0.025em 0 var(--secondary-color);
      }
      49% {
        text-shadow: -0.05em -0.025em 0 var(--primary-color), 0.025em 0.025em 0 var(--secondary-color);
      }
      50% {
        text-shadow: 0.025em 0.05em 0 var(--primary-color), 0.05em 0 0 var(--secondary-color);
      }
      99% {
        text-shadow: 0.025em 0.05em 0 var(--primary-color), 0.05em 0 0 var(--secondary-color);
      }
      100% {
        text-shadow: -0.025em 0 0 var(--primary-color), -0.025em -0.025em 0 var(--secondary-color);
      }
    }

    /* Barra de progreso mejorada */
    .loading-container {
      width: 100%;
      max-width: 400px;
      margin: 20px 0;
    }

    .loading-bar {
      width: 100%;
      height: 8px;
      background: rgba(255, 255, 255, 0.1);
      border-radius: 10px;
      overflow: hidden;
      position: relative;
      box-shadow: inset 0 0 5px rgba(0, 0, 0, 0.5);
    }

    .loading-progress {
      position: absolute;
      left: 0;
      top: 0;
      height: 100%;
      width: 0%;
      background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
      box-shadow: 0 0 10px var(--primary-color);
      transition: width 0.3s ease-out;
    }

    .progress-percentage {
      font-family: 'Orbitron', sans-serif;
      font-size: 1rem;
      color: var(--secondary-color);
      margin-top: 10px;
      text-shadow: 0 0 5px var(--primary-color);
    }

    .vhs-effect {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        linear-gradient(rgba(0, 240, 255, 0.03) 0%, transparent 5%),
        linear-gradient(0deg, rgba(255, 0, 193, 0.03) 0%, transparent 5%);
      background-size: 100% 8px;
      pointer-events: none;
      z-index: 3;
      animation: scanlines 0.5s linear infinite;
    }

    @keyframes scanlines {
      from { background-position: 0 0; }
      to { background-position: 0 8px; }
    }

    .grid-lines {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        linear-gradient(to right, 
          rgba(255, 0, 193, 0.05) 1px, 
          transparent 1px),
        linear-gradient(to bottom, 
          rgba(0, 240, 255, 0.05) 1px, 
          transparent 1px);
      background-size: 20px 20px;
      pointer-events: none;
      z-index: 1;
    }

    @media (max-width: 768px) {
      .title { 
        font-size: 1.5rem; 
        padding: 10px;
      }
      .video-container { 
        max-width: 95%;
        max-height: 50vh;
      }
      .buttons-container {
        flex-direction: column;
        align-items: center;
      }
      .boton { 
        width: 90%;
        font-size: 0.9rem;
      }
      .redirect-text {
        font-size: 1rem;
      }
    }
  </style>
</head>
<body class="fade-in">
  <div id="cerrarSesionContainer" style="margin-top: 30px; display:none;">
    <button id="btnCerrarSesion" class="btn btn-outline-light">🔒 Cerrar sesión</button>
  </div>
<style>#btnCerrarSesion {
    background: linear-gradient(45deg, #ff00ff, #00ffff);
    border: none;
    color: white;
    padding: 10px 20px;
    text-transform: uppercase;
    font-family: 'Courier New', monospace;
    font-weight: bold;
    letter-spacing: 2px;
    border-radius: 0;
    box-shadow: 0 0 10px rgba(255, 0, 255, 0.7),
                0 0 20px rgba(0, 255, 255, 0.5);
    text-shadow: 0 0 5px #fff;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

#btnCerrarSesion:hover {
    background: linear-gradient(45deg, #00ffff, #ff00ff);
    box-shadow: 0 0 15px rgba(255, 0, 255, 0.9),
                0 0 25px rgba(0, 255, 255, 0.7);
    transform: translateY(-2px);
}

#btnCerrarSesion::before {
    content: "";
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: linear-gradient(
        to bottom right,
        rgba(255, 255, 255, 0.3) 0%,
        rgba(255, 255, 255, 0) 60%
    );
    transform: rotate(30deg);
}

#btnCerrarSesion:hover::before {
    animation: shine 1.5s infinite;
}

@keyframes shine {
    0% {
        left: -50%;
    }
    100% {
        left: 150%;
    }
}</style>
  <h1 class="title">BAR</h1>

  <div class="video-container" id="video-container">
    <video autoplay muted loop playsinline>
      <source src="https://nodo25.netfan.host/humclubdemusica/files/bares2.mp4" type="video/mp4">
    </video>
  </div>

  <div class="buttons-container">


    <a id="btn-bar" href="bar.php" class="boton" style="display:none" data-sound="files/6.mp3">Ingresar a sistema de Bar</a>
    <a id="btn-dashboard" href="dashboard.php" class="boton" style="display:none" data-sound="files/6.mp3">Dashboard</a>
  </div>

  <!-- Overlay Vaporwave mejorado -->
  <div id="redirect-overlay">
    <div class="vhs-effect"></div>
    <div class="grid-lines"></div>
    
    <div class="redirect-content">
      <div class="redirect-text">
        <span> Ingresando </span>
      </div>
      
      <div class="loading-container">
        <div class="loading-bar">
          <div class="loading-progress" id="loading-progress"></div>
        </div>
        <div class="progress-percentage" id="progress-percentage">0%</div>
      </div>
      
      <div class="redirect-text">
        <span>Por favor espere...</span>
      </div>
    </div>
  </div>

  <script>
    const overlay = document.getElementById('redirect-overlay');
    const videoContainer = document.getElementById('video-container');
    const loadingProgress = document.getElementById('loading-progress');
    const progressPercentage = document.getElementById('progress-percentage');

    document.querySelectorAll('.boton').forEach(boton => {
      boton.addEventListener('click', function(e) {
        e.preventDefault();

        const soundUrl = this.getAttribute('data-sound');
        const destination = this.getAttribute('href');
        const audio = new Audio(soundUrl);

        // Start the loading animation
        overlay.classList.add('active');
        
        // Reset progress
        loadingProgress.style.width = '0%';
        progressPercentage.textContent = '0%';
        
        // Play the sound
        audio.play();
        
        // Create a glitch effect on the video before redirecting
        videoContainer.style.filter = 'hue-rotate(180deg) contrast(1.5)';
        
        // Add some VHS distortion effect
        setTimeout(() => {
          videoContainer.style.transform = 'scale(1.02)';
          videoContainer.style.filter = 'hue-rotate(90deg) contrast(1.8) saturate(2)';
        }, 300);
        
        setTimeout(() => {
          videoContainer.style.transform = 'scale(1)';
          videoContainer.style.filter = 'hue-rotate(270deg) contrast(2) saturate(3)';
        }, 600);

        // Simulate realistic loading progress
        let progress = 0;
        const progressInterval = setInterval(() => {
          if (progress < 90) {
            // Avance más lento al principio
            progress += Math.random() * 15;
            if (progress > 90) progress = 90;
          } else {
            // Últimos porcentajes más lentos
            progress += Math.random() * 2;
          }
          
          progress = Math.min(progress, 100);
          loadingProgress.style.width = `${progress}%`;
          progressPercentage.textContent = `${Math.floor(progress)}%`;
          
          if (progress >= 100) {
            clearInterval(progressInterval);
            document.body.classList.remove('fade-in');
            document.body.classList.add('fade-out');
            videoContainer.classList.add('fade-out');
            
            setTimeout(() => {
              window.location.href = destination;
            }, 300);
          }
        }, 300);
      });
    });
  </script>

<!-- MODAL DE LOGIN -->
<div class="modal fade" id="loginModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content bg-dark text-white">
      <div class="modal-header border-0">
        <h5 class="modal-title">Iniciar sesión</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="formLogin">
          <div class="mb-3">
            <label class="form-label">Usuario</label>
            <input type="text" name="usuario" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Clave</label>
            <input type="password" name="clave" class="form-control" required>
          </div>
          <input type="hidden" name="destino" id="destinoLogin">
          <div class="text-danger mb-2" id="loginError" style="display:none;">Credenciales incorrectas</div>
          <button type="submit" class="btn btn-primary w-100">Ingresar</button>
        </form>
      </div>
    </div>
  </div>
</div>
<style>
<style>
  /* Modal más pequeño y compacto */
  #loginModal .modal-dialog {
    max-width: 320px;
    margin: 2rem auto; /* un poco más abajo */
  }

  /* Fondo oscuro translúcido */
  #loginModal .modal-content {
    background: transparent;
    backdrop-filter: blur(8px);
    border: none;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    overflow: hidden;
    position: relative;
  }

  /* Borde fino blanco */
  #loginModal .modal-content::after {
    content: '';
    position: absolute;
    inset: 0;
    border-radius: 10px;
    padding: 0.5px;
    background: rgba(255, 255, 255, 0.15);
    -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
    pointer-events: none;
  }

  /* Header más bajo y sin botón de cerrar */
  #loginModal .modal-header {
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    padding: 0.75rem 1rem;
  }

  #loginModal .modal-title {
    color: white;
    font-size: 1rem;
    font-weight: 500;
    margin: 0 auto;
  }

  /* Ocultamos el botón cerrar (X) */
  #loginModal .btn-close {
    display: none;
  }

  /* Cuerpo del modal compacto */
  #loginModal .modal-body {
    padding: 1rem;
  }

  #loginModal .form-control {
    background: rgba(255, 255, 255, 0.08);
    border: 1px solid rgba(255, 255, 255, 0.1);
    color: white;
    border-radius: 6px;
    padding: 8px 12px;
    margin-bottom: 0.8rem;
    font-size: 0.9rem;
  }

  #loginModal .btn-login {
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    color: white;
    border-radius: 6px;
    padding: 8px 0;
    font-size: 0.9rem;
    width: 100%;
    transition: all 0.2s ease;
  }

  #loginModal .btn-login:hover {
    background: rgba(255, 255, 255, 0.15);
  }
</style>

</style>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<script>
  window.addEventListener('DOMContentLoaded', () => {
    const modal = new bootstrap.Modal(document.getElementById('loginModal'));
    modal.show();
  });

  document.getElementById('formLogin').addEventListener('submit', function(e) {
    e.preventDefault();
    const form = e.target;
    const data = new FormData(form);
    const loginError = document.getElementById('loginError');

    fetch('procesar_login.php', {
      method: 'POST',
      body: data
    })
    .then(res => res.json())
    .then(json => {
      if (json.success) {
        const nivel = json.nivel;

        // Mostrar botones según nivel
        if (nivel === 'admin') {
          ['btn-camaras', 'btn-whatsapp', 'btn-bar', 'btn-salas', 'btn-dashboard'].forEach(id => {
            const btn = document.getElementById(id);
            if (btn) btn.style.display = 'inline-block';
          });
        } else {
          ['btn-bar', 'btn-salas'].forEach(id => {
            const btn = document.getElementById(id);
            if (btn) btn.style.display = 'inline-block';
          });
        }

        // Mostrar botón cerrar sesión (solo si login fue exitoso)
        document.getElementById('cerrarSesionContainer').style.display = 'block';

        // Ocultar el modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('loginModal'));
        modal.hide();
      } else {
        loginError.style.display = 'block';
      }
    })
    .catch(err => {
      console.error('Error al procesar login:', err);
      loginError.style.display = 'block';
    });
  });

  document.getElementById('btnCerrarSesion').addEventListener('click', () => {
    fetch('cerrar_sesion.php')
      .then(() => {
        window.location.reload();
      });
  });
</script>


</body>
</html>