<?php
/**
 * mapa_mesas_vertical.php – FIX faltaban mesas 9 y 10 (04‑Ago‑2025)
 * ---------------------------------------------------------------
 * Inserta automáticamente las 10 mesas (IDs 1‑10) si no existen.
 * Luego las muestra tal cual estén (en el mapa o inventario).
 */

session_start();
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// Ajustes rápidos
const TOT_MESAS = 10;
const IFRAME_H = 420;
const MAP_H    = 300;
const MESA_SZ  = 32;
const INV_W    = 60;

/* ---------- Garantizar columnas ---------- */
function ensure($con,$col,$sql){
  if(!mysqli_num_rows($con->query("SHOW COLUMNS FROM mesas LIKE '$col'")))
      $con->query($sql);
}
ensure($con,'pos_x', "ALTER TABLE mesas ADD COLUMN pos_x INT UNSIGNED NOT NULL DEFAULT 0");
ensure($con,'pos_y', "ALTER TABLE mesas ADD COLUMN pos_y INT UNSIGNED NOT NULL DEFAULT 0");
ensure($con,'placed',"ALTER TABLE mesas ADD COLUMN placed TINYINT(1) NOT NULL DEFAULT 0");

/* ---------- Garantizar filas 1‑10 ---------- */
for($i=1;$i<=TOT_MESAS;$i++){
  $con->query("INSERT IGNORE INTO mesas (id,nombre) VALUES ($i,'Mesa $i')");
}

/* ---------- Guardado individual ---------- */
if(isset($_POST['mesa_id'])){
  header('Content-Type: application/json');
  $id = intval($_POST['mesa_id']);
  $x  = intval($_POST['x'] ?? 0);
  $y  = intval($_POST['y'] ?? 0);
  $p  = intval($_POST['placed']);
  $st = $con->prepare("UPDATE mesas SET pos_x=?, pos_y=?, placed=? WHERE id=? LIMIT 1");
  $st->bind_param('iiii', $x, $y, $p, $id);
  echo json_encode(['success' => $st->execute()]);
  exit;
}

/* ---------- Guardado masivo ---------- */
if(isset($_POST['save_bulk'])){
  header('Content-Type: application/json');
  $arr = json_decode($_POST['data'] ?? '[]', true);
  if(!$arr || !is_array($arr)){
    echo json_encode(['success'=>false,'msg'=>'Datos vacíos']); exit;
  }
  $con->begin_transaction();
  $st = $con->prepare("UPDATE mesas SET pos_x=?, pos_y=?, placed=? WHERE id=? LIMIT 1");
  foreach($arr as $m){
    $st->bind_param('iiii',$m['x'],$m['y'],$m['placed'],$m['id']);
    if(!$st->execute()){ $con->rollback(); echo json_encode(['success'=>false,'msg'=>$con->error]); exit; }
  }
  $con->commit();
  echo json_encode(['success'=>true,'count'=>count($arr)]); exit;
}

/* ---------- Datos ---------- */
$mesas = $con->query("SELECT id,nombre,pos_x,pos_y,placed FROM mesas ORDER BY id")
            ->fetch_all(MYSQLI_ASSOC);
$inv   = array_filter($mesas, fn($m)=>$m['placed']==0);
$plano = array_filter($mesas, fn($m)=>$m['placed']==1);
?>
<!DOCTYPE html>
<html lang="es"><head><meta charset="utf-8">
<title>Mapa Mesas</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<style>
:root{ --mesa:<?=MESA_SZ?>px; --inv:<?=INV_W?>px;}
html,body{margin:0;height:100%;overflow:hidden;background:#eef5ff;font-size:12px;}
#wrap{display:flex;flex-direction:column;height:<?=IFRAME_H?>px;}
#mapa{height:<?=MAP_H?>px;background:url('img/floorplan.svg') center/contain no-repeat;position:relative;overflow:hidden;}
#zona{flex:1;display:flex;border-top:1px solid #ccd;}
#inv{width:var(--inv);padding:8px;border-right:1px solid #ccd;overflow:auto;}
#cfg{flex:1;padding:8px;overflow:auto;}
.mesa{width:var(--mesa);height:var(--mesa);background:#90caf9;border-radius:5px;
      display:flex;align-items:center;justify-content:center;font-weight:600;
      color:#08326b;cursor:grab;user-select:none;box-shadow:0 1px 3px rgba(0,0,0,.3);
      transition:transform .12s;}
.mesa:hover{transform:scale(1.06);}
#inv .mesa{margin:4px auto;position:relative;}
.lbl{position:absolute;top:2px;left:4px;font-size:10px;color:#555;}
</style></head><body>
<div id="wrap">
  <!-- mapa -->
  <div id="mapa">
    <?php foreach($plano as $m): ?>
      <div class="mesa" data-id="<?=$m['id']?>"
           style="left:<?=$m['pos_x']?>px; top:<?=$m['pos_y']?>px; position:absolute;">
        <?=htmlspecialchars($m['nombre'])?>
      </div>
    <?php endforeach; ?>
  </div>

  <!-- inventario + cfg -->
  <div id="zona">
    <div id="inv"><span class="lbl">Inv.</span>
      <?php foreach($inv as $m): ?>
        <div class="mesa" data-id="<?=$m['id']?>"><?=htmlspecialchars($m['nombre'])?></div>
      <?php endforeach; ?>
    </div>
    <div id="cfg">
      <button id="btnGuardar" class="btn btn-sm btn-primary mb-2">💾 Guardar posiciones</button>
      <div class="small text-muted">Arrastrá las mesas y luego pulsá el botón para persistir.</div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(function(){
  function makeDrag($e){
    $e.draggable({helper:'clone',revert:'invalid',start:()=>{$e.css('opacity',.4)},stop:()=>{$e.css('opacity',1)}});
  }
  makeDrag($('.mesa'));

  $('#mapa').droppable({accept:'.mesa',drop:function(e,ui){
      const $m=ui.draggable;const off=$(this).offset();
      $m.appendTo('#mapa');$m.css({position:'absolute',left:ui.offset.left-off.left,top:ui.offset.top-off.top});makeDrag($m);
  }});
  $('#inv').droppable({accept:'.mesa',drop:function(e,ui){
      const $m=ui.draggable;$m.css({position:'relative',left:'',top:''}).appendTo('#inv');makeDrag($m);
  }});

  $(document).on('click','.mesa',function(){
      const id=$(this).data('id');alert('Abrir modal mesa '+id); // placeholder
  });

  $('#btnGuardar').click(function(){
      const arr=[];$('.mesa').each(function(){
          const $m=$(this);const id=$m.data('id');
          const placed=$m.parent().attr('id')==='mapa'?1:0;
          const x=placed?parseInt($m.css('left'))||0:0;
          const y=placed?parseInt($m.css('top'))||0:0;
          arr.push({id,x,y,placed});
      });
      $.post(location.pathname,{save_bulk:1,data:JSON.stringify(arr)},'json')
        .done(d=>alert(d.success?'Posiciones guardadas ✅':'Error: '+(d.msg||'desconocido')));
  });
});
</script>
</body></html>
