<?php
require_once 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$res = mysqli_query($con, "SELECT * FROM comandas_cocina WHERE estado = 2 ORDER BY hora DESC");

?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Historial de Cocina</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .comanda { border-left: 6px solid gray; margin-bottom: 1rem; padding: 1rem; background: #fff; box-shadow: 0 2px 6px rgba(0,0,0,.1); }
    .comanda h5 { margin-bottom: .5rem; }
    .comanda ul { padding-left: 1.2rem; }
    body { background: #f8f9fa; padding: 2rem; }
  </style>
</head>
<body>

<h4 class="mb-4">📦 Historial de Comandas Despachadas</h4>

<?php while ($c = mysqli_fetch_assoc($res)): ?>
  <?php
    $productos = json_decode($c['detalle'], true);
    $hora = date('H:i', strtotime($c['hora']));
  ?>
  <div class="comanda">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <span class="badge bg-secondary text-white">Mesa <?= $c['mesa_id'] ?></span>
      <span class="text-muted"><i class="bi bi-clock"></i> <?= $hora ?></span>
    </div>
    <ul>
      <?php if (is_array($productos)): ?>
        <?php foreach ($productos as $p): ?>
          <li><?= $p['cantidad'] ?>x <?= htmlspecialchars($p['nombre'] ?? 'Sin nombre') ?></li>
        <?php endforeach; ?>
      <?php else: ?>
        <li class="text-danger">⚠️ Error: detalle corrupto</li>
      <?php endif; ?>
    </ul>
  </div>
<?php endwhile; ?>

</body>
</html>
