<?php
// ajax/ajax_precio_sala.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
header('Content-Type: application/json');

if (!isset($_POST['sala_id']) || !isset($_POST['hora'])) {
    echo json_encode(['error' => 'Datos incompletos']);
    exit;
}

$sala_id = intval($_POST['sala_id']);
$hora = $_POST['hora'] . ':00'; // formato completo

// Obtenemos todas las franjas para esta sala
$sql = "SELECT * FROM precios_horarios WHERE sala_id = ?";
$stmt = mysqli_prepare($con, $sql);
mysqli_stmt_bind_param($stmt, 'i', $sala_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$precio = 0;
while ($row = mysqli_fetch_assoc($result)) {
    $desde = $row['desde_hora'];
    $hasta = $row['hasta_hora'];

    if ($desde < $hasta) {
        // Franja normal
        if ($hora >= $desde && $hora < $hasta) {
            $precio = $row['precio_hora'];
            break;
        }
    } else {
        // Franja que cruza medianoche
        if ($hora >= $desde || $hora < $hasta) {
            $precio = $row['precio_hora'];
            break;
        }
    }
}

echo json_encode(['precio' => floatval($precio)]);
