<?php session_start(); ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Iniciar sesión</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-white">
  <div class="container mt-5">
    <div class="row justify-content-center">
      <div class="col-md-4">
        <div class="card shadow">
          <div class="card-body bg-secondary text-white">
            <h4 class="text-center mb-4">Iniciar sesión</h4>
            <?php if (isset($_GET['error'])): ?>
              <div class="alert alert-danger">Usuario o clave incorrectos</div>
            <?php endif; ?>

            <!-- FORMULARIO -->
            <form action="procesar_login.php" method="post" autocomplete="off">
              <!-- TRUCO anti-autocompletado -->
              <input type="text" name="fakeuser" style="display:none">
              <input type="password" name="fakepass" style="display:none">

              <input type="hidden" name="destino" value="<?= htmlspecialchars($_GET['destino'] ?? 'index.php') ?>">

              <div class="mb-3">
                <label>Usuario</label>
                <input type="text" name="usuario" class="form-control" autocomplete="off" required>
              </div>
              <div class="mb-3">
                <label>Clave</label>
                <input type="password" name="clave" class="form-control" autocomplete="new-password" required>
              </div>
              <button type="submit" class="btn btn-primary w-100">Ingresar</button>
            </form>
          </div>
        </div>
        <div class="text-center mt-3">
          <a href="index.php" class="text-light">← Volver al inicio</a>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
