<?php
// Configuración
$para = 'lagarpropiedades@gmail.com'; // Email de destino
$redireccion_exito = 'index.php?ok=1';   // Redirigir tras éxito
$redireccion_error = 'index.php?error=1';// Redirigir tras error
$tiempo_redireccion = 3; // Segundos antes de redireccionar

// Validación básica
if (empty($_POST['nombre']) || empty($_POST['mensaje'])) {
    header("Location: $redireccion_error");
    exit;
}

// Sanitización
$nombre   = isset($_POST['nombre'])   ? filter_var($_POST['nombre'],   FILTER_SANITIZE_STRING) : '';
$telefono = isset($_POST['telefono']) ? filter_var($_POST['telefono'], FILTER_SANITIZE_STRING) : '';
$mensaje  = isset($_POST['mensaje'])  ? nl2br(filter_var($_POST['mensaje'],  FILTER_SANITIZE_STRING)) : '';

// Email
$asunto       = "Nueva consulta desde formulario web";
$nombre_envio = "Sitio Web";
$email_reply  = "no-responder@netfan.host";

$html = "<!DOCTYPE html>
<html><head><meta charset='utf-8'>
<style>body{font-family:Arial,sans-serif;line-height:1.6}.datos{background:#f9f9f9;padding:15px;border-radius:5px}strong{color:#333}</style>
</head><body>
  <h3>Consulta desde sitio web</h3>
  <div class='datos'>
    <p><strong>Nombre:</strong> {$nombre}</p>
    <p><strong>Teléfono:</strong> {$telefono}</p>
    <p><strong>Mensaje:</strong><br>{$mensaje}</p>
  </div>
</body></html>";

$post = [
    'html'         => base64_encode($html),
    'asunto'       => base64_encode($asunto),
    'nombre_envio' => base64_encode($nombre_envio),
    'email_reply'  => base64_encode($email_reply),
    'nombre'       => base64_encode($nombre),
    'para'         => base64_encode($para)
];

// cURL
$ch = curl_init("http://envios.netfan.host/mailer.php");
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => http_build_query($post),
    CURLOPT_TIMEOUT        => 10,
    CURLOPT_SSL_VERIFYPEER => false // usando http; desactivamos por compat.
]);

$response = curl_exec($ch);
$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$err      = curl_error($ch);
curl_close($ch);

// Página de respuesta
header('Content-Type: text/html; charset=utf-8');
$ok = ($httpcode === 200 && trim($response) === 'OK');
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Envío de formulario</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{background-color:#f8f9fa;display:flex;justify-content:center;align-items:center;min-height:100vh;margin:0}
    .feedback{max-width:560px;width:92%;background:#fff;border-radius:12px;box-shadow:0 10px 30px rgba(0,0,0,.08);padding:2rem;text-align:center}
  </style>
</head>
<body>
  <div class="feedback">
    <?php if ($ok): ?>
      <h2 class="text-success">✅ Mensaje enviado correctamente</h2>
      <p>Gracias por contactarnos. Te redireccionaremos en breve…</p>
    <?php else: ?>
      <h2 class="text-danger">✅ Mensaje enviado correctamente</h2>
      <p>Gracias por contactarnos. Te redireccionaremos en breve…</p>
      <?php if (!empty($err)): ?>
        <p class="text-muted small">Detalle técnico: <?= htmlspecialchars($err) ?></p>
      <?php endif; ?>
    <?php endif; ?>
    <div class="spinner-border text-primary my-3" role="status"><span class="visually-hidden">Cargando…</span></div>
    <p class="small text-muted">Redireccionando en <?= (int)$tiempo_redireccion ?> segundos…</p>
  </div>
  <script>
    setTimeout(function(){ window.location.href = "<?= $ok ? $redireccion_exito : $redireccion_error ?>"; }, <?= (int)$tiempo_redireccion * 1000 ?>);
  </script>
</body>
</html>
