<?php
require 'conexion.php';

/* ===========================
   Propiedades destacadas
   =========================== */
$gal = $conn->query("
  SELECT p.id, p.titulo, p.imagen, p.tipo
  FROM propiedades_destacadas d
  JOIN propiedades p ON p.id = d.propiedad_id
  WHERE d.activo = 1
  ORDER BY d.orden ASC, d.id DESC
  LIMIT 9
");
if (!$gal || $gal->num_rows === 0) {
  $gal = $conn->query("
    SELECT id, titulo, imagen, tipo
    FROM propiedades
    ORDER BY id DESC
    LIMIT 9
  ");
}

/* ===========================
   Captura de filtros (buscador)
   =========================== */
$localidad = $_GET['localidad'] ?? '';
$barrio    = $_GET['barrio']    ?? '';
$operacion = $_GET['operacion'] ?? '';
$tipo      = $_GET['tipo']      ?? '';
$ambientes = $_GET['ambientes'] ?? '';

/* ===========================
   Consulta para modal de resultados
   =========================== */
$filtros = [];
if ($localidad) $filtros[] = "localidad = '".$conn->real_escape_string($localidad)."'";
if ($barrio)    $filtros[] = "barrio    = '".$conn->real_escape_string($barrio)."'";
if ($operacion) $filtros[] = "operacion = '".$conn->real_escape_string($operacion)."'";
if ($tipo)      $filtros[] = "tipo      = '".$conn->real_escape_string($tipo)."'";
if ($ambientes) $filtros[] = "ambientes = ".intval($ambientes);

$sqlResult = "SELECT id, titulo, tipo, imagen FROM propiedades";
if ($filtros) $sqlResult .= " WHERE ".implode(' AND ', $filtros);
$resultados   = $conn->query($sqlResult);
$mostrarModal = !empty($filtros);

/* ===========================
   Traer localidades
   =========================== */
$loc_query = $conn->query("SELECT DISTINCT localidad FROM propiedades WHERE localidad <> '' ORDER BY localidad ASC");
$localidades = $loc_query ? $loc_query->fetch_all(MYSQLI_ASSOC) : [];
?>
<!DOCTYPE html>
<html lang="es-AR">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Lagar Servicios Inmobiliarios | Compra, Venta y Tasación de Propiedades en Buenos Aires</title>
  <meta name="description" content="David Lagar Servicios Inmobiliarios. Compra, venta y tasación de casas, departamentos y terrenos en Buenos Aires. Asesoramiento legal y contable, experiencia y confianza. Atención personalizada.">

  <!-- Canonical -->
  <link rel="canonical" href="https://lagarpropiedades.com/" />

  <!-- Favicon -->
  <link rel="icon" href="https://lagarpropiedades.com/img/faviconcin.png" type="image/png">

  <!-- Open Graph / Facebook -->
  <meta property="og:type" content="website">
  <meta property="og:title" content="Lagar Servicios Inmobiliarios">
  <meta property="og:description" content="Compra, venta y tasación de propiedades en Buenos Aires. Asesoramiento integral con respaldo legal y contable.">
  <meta property="og:url" content="https://lagarpropiedades.com/">
  <meta property="og:image" content="https://lagarpropiedades.com/img/13png">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Lagar Servicios Inmobiliarios">
  <meta name="twitter:description" content="Compra, venta y tasación de propiedades en Buenos Aires con respaldo legal y contable.">
  <meta name="twitter:image" content="https://lagarpropiedades.com/img/13.png">

  <!-- CSS & Fuentes -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&family=Playfair+Display:wght@400;700&display=swap" rel="stylesheet">
</head>


  <style>
    :root{
      --primary:#8f82ae; --primary-600:#7c6ca0; --primary-700:#6b5d90;
      --dark:#1e293b; --muted:#64748b; --line:#e2e8f0; --bg:#f8fafc;
      --radius:14px; --shadow:0 6px 18px rgba(2,8,23,.08); --shadow-lg:0 14px 32px rgba(2,8,23,.15);
      --grad:linear-gradient(135deg, var(--primary) 0%, #5d89ff 100%);
    }
    *{box-sizing:border-box}
    body{font-family:'Poppins',system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,'Helvetica Neue',Arial,sans-serif;color:var(--dark);background:#fff;line-height:1.6;overflow-x:hidden}
    h1,h2,h3,h4{font-family:'Playfair Display',serif}

    /* NAVBAR */
    .navbar-premium{background: rgba(17, 24, 39, .6);backdrop-filter:saturate(140%) blur(8px);-webkit-backdrop-filter:saturate(140%) blur(8px);border-bottom:1px solid rgba(255,255,255,.08)}
    .navbar-premium .navbar-brand{font-weight:700;letter-spacing:.2px;overflow:hidden}
    .brand-img{height:28px}
    .brand-text{display:block;max-width:60vw;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}

    /* BUSCADOR */
    .search-wrap{background:var(--grad);color:#fff;padding:1.6rem 0 1.2rem;box-shadow:var(--shadow)}
    .search-wrap .form-label{color:#fff;font-weight:600;margin-bottom:.35rem}
    .search-wrap .form-select,.search-wrap .form-control{border:1px solid rgba(255,255,255,.4);color:#0f172a;background:#fff;border-radius:10px;height:44px}
    .btn-theme{background:var(--primary);border:none;border-radius:12px;padding:.62rem 1rem;font-weight:600;box-shadow:var(--shadow);transition:.25s}
    .btn-theme:hover{background:var(--primary-600);transform:translateY(-1px);box-shadow:var(--shadow-lg)}

    /* === HERO carrusel sin estirar === */
.hero{
  min-height:48vh;
  position:relative;
  display:grid;
  place-items:center;
  overflow:hidden;
  isolation:isolate;
  background:none !important;   /* quitamos el fallback con fixed */
}

/* pista y slide */
.hero__slides{ position:absolute; inset:0; z-index:0; }
.hero__slide{  position:absolute; inset:0; opacity:0; transition:opacity .9s ease; }
.hero__slide.is-active{ opacity:1; }

/* imagen que nunca se deforma */
/* ocupa TODO el hero y no se deforma */
.hero__img{
  width:100%;
  height:100%;
  display:block;
  object-fit:cover;           /* llena recortando si hace falta */
  background:transparent;
}

/* solo si querés ver la foto completa con bandas */
.hero--contain .hero__img{
  object-fit:contain;
  background:#000;
}
/* el slide de atrás rellena todo */
.hero--contain .hero__slide{
  background-position:center;
  background-size:cover;
  background-repeat:no-repeat;
}

/* la imagen principal va en contain, pero SIN fondo negro */
.hero--contain .hero__img{
  width:100%;
  height:100%;
  display:block;
  object-fit:contain;
  background:transparent;   /* ← antes estaba #000, eso generaba las bandas */
}

/* overlay y contenido */
.hero::after{
  content:''; position:absolute; inset:0; z-index:1;
  background:linear-gradient(180deg, rgba(0,0,0,.45), rgba(0,0,0,.25) 40%, rgba(0,0,0,.55));
}
.hero-inner{ position:relative; z-index:2; text-align:center; color:#fff; padding:2.6rem 1rem; }

/* mobile */
@media (max-width:992px){
  .hero{ min-height:36vh; }
}

    /* SECCIONES Y CARDS */
    .section{padding: clamp(2rem, 5vw, 5rem) 0}
    .section-title{position:relative;display:inline-block;margin-bottom:1rem}
    .section-title::after{content:'';position:absolute;left:0;bottom:-10px;width:72px;height:4px;background:var(--primary);border-radius:2px}
    .lead-muted{color:var(--muted)}
    .img-elev{border-radius:var(--radius);box-shadow:var(--shadow-lg);object-fit:cover}
    .img-cover{min-height:320px;border-radius:16px;box-shadow:var(--shadow-lg);background:var(--grad);background-size:cover;background-position:center}

    .prop-card{border:none;border-radius:16px;overflow:hidden;background:#fff;box-shadow:var(--shadow);transition:.28s;height:100%}
    .prop-card:hover{transform:translateY(-6px);box-shadow:var(--shadow-lg)}
    .prop-img-wrap{height:220px;overflow:hidden;position:relative}
    .prop-img{width:100%;height:100%;object-fit:cover;transition:transform .5s ease}
    .prop-card:hover .prop-img{transform:scale(1.06)}
    .prop-type{position:absolute;top:12px;right:12px;background:rgba(255,255,255,.95);color:var(--primary-700);padding:.3rem .7rem;border-radius:999px;font-weight:700;font-size:.8rem;border:1px solid var(--line)}
    .prop-body{padding:1rem 1.1rem 1.2rem}
    .prop-title{font-weight:700;color:#0f172a;font-size:1.05rem;margin:0}
    .prop-link{display:inline-flex;align-items:center;gap:.35rem;margin-top:.65rem;font-weight:600;color:var(--primary)}
    .prop-link:hover{color:var(--primary-600)}
    .filter-chips{display:flex;flex-wrap:wrap;gap:.5rem;justify-content:center;margin-bottom:1.2rem}
    .chip{background:#fff;border:1px solid var(--line);border-radius:999px;padding:.45rem .9rem;font-weight:600;color:var(--muted);box-shadow:var(--shadow);cursor:pointer}
    .chip.active,.chip:hover{background:var(--primary);color:#fff;border-color:transparent}

    .list-thumb{width:110px;height:74px;object-fit:cover;border-radius:10px;border:1px solid var(--line)}
    .cta-pane{background:linear-gradient(135deg, rgba(255,255,255,.92), rgba(255,255,255,.92)), var(--grad);border:1px solid var(--line);border-radius:16px;box-shadow:var(--shadow);padding:1.4rem}

    /* FOOTER */
    .site-footer{
      color:#e2e8f0;
      background: linear-gradient(180deg, rgba(15,23,42,.96), rgba(15,23,42,.98)),
                  radial-gradient(1200px 600px at 10% -10%, rgba(143,130,174,.25), transparent 60%);
    }
    .footer-logo{height:32px}
    .footer-title{color:#fff; font-weight:700; letter-spacing:.02em; margin-bottom:.6rem}
    .footer-text{color:#cbd5e1}
    .footer-link{color:#cbd5e1; text-decoration:none}
    .footer-link:hover{color:var(--primary, #8f82ae)}
    .footer-brand{color:#fff}
    .footer-social{color:#cbd5e1; text-decoration:none}
    .footer-social:hover{color:var(--primary, #8f82ae)}
    .footer-cta{background:rgba(255,255,255,.04); border:1px solid rgba(255,255,255,.08); border-radius:14px}
    .footer-sep{border-color:rgba(255,255,255,.12)}

    
/* WHATSAPP widget (corregido) */
:root{
  --whatsapp-green:#25D366;--whatsapp-dark:#075E54;--whatsapp-light:#DCF8C6;
  --w-text:#4A4A4A;--w-muted:#757575;--w-bg:#FFFFFF;--w-gray:#F0F0F0
}
.whatsapp-chat-container{
  position:fixed;bottom:22px;right:22px;
  z-index:2147483647; /* siempre arriba de todo */
  font-family:'Segoe UI',Helvetica,Arial,sans-serif
}
.whatsapp-closed{position:relative;transition:.3s}
.chat-button{
  display:flex;align-items:center;justify-content:center;
  width:58px;height:58px;border-radius:50%;
  background:var(--whatsapp-green);
  box-shadow:0 5px 15px rgba(37,211,102,.4);
  color:#fff;font-size:28px;position:relative;cursor:pointer;transition:.3s
}
.notification-badge{
  position:absolute;top:-5px;right:-5px;background:#FF3B30;color:#fff;border-radius:50%;
  width:20px;height:20px;display:flex;align-items:center;justify-content:center;font-size:10px;font-weight:700
}
.chat-tooltip{
  position:absolute;right:80px;top:50%;transform:translateY(-50%);
  background:var(--w-bg);color:var(--w-text);width:240px;border-radius:10px;
  box-shadow:0 5px 15px rgba(0,0,0,.1);opacity:0;visibility:hidden;transition:.3s;overflow:hidden;z-index:1
}
.whatsapp-closed:hover .chat-tooltip{opacity:1;visibility:visible;right:72px}

.whatsapp-open{
  width:300px;background:var(--w-bg);border-radius:10px;
  box-shadow:0 5px 30px rgba(0,0,0,.2);overflow:hidden;
  display:none;flex-direction:column;height:450px
}
.whatsapp-open .chat-header{background:var(--whatsapp-dark)}

/* Estado ABIERTO: se agrega .chat-visible desde JS */
.whatsapp-chat-container.chat-visible .whatsapp-open{display:flex}
.whatsapp-chat-container.chat-visible .whatsapp-closed{display:none}
.whatsapp-chat-container.chat-visible .chat-tooltip{display:none}

.chat-header{
  display:flex;align-items:center;padding:12px;background:var(--whatsapp-dark);color:#fff;position:relative
}
.close-chat{background:none;border:none;color:#fff;cursor:pointer;font-size:16px;opacity:.8}
.chat-avatar{width:40px;height:40px;border-radius:50%;margin-right:10px;object-fit:cover}
.chat-info{flex:1}
.chat-info strong{display:block;font-size:14px}
.chat-info small{font-size:11px;opacity:.8}
.chat-preview{padding:12px;font-size:13px;border-bottom:1px solid var(--w-gray)}

.chat-messages{flex:1;padding:10px;overflow-y:auto;background:#e5ddd5}
.message{display:flex;margin-bottom:10px;max-width:80%}
.message-content{padding:8px 12px;border-radius:7.5px;font-size:14px}
.message.received .message-content{background:#fff;color:var(--w-text);border-top-left-radius:0}
.message.sent{align-self:flex-end;flex-direction:row-reverse}
.message.sent .message-content{background:var(--whatsapp-light);color:var(--w-text);border-top-right-radius:0}

.chat-input{display:flex;padding:10px;background:var(--w-gray);border-top:1px solid #ddd}
.chat-input input{flex:1;border:none;border-radius:20px;padding:10px 15px;font-size:14px;outline:none;background:#fff}
.send-button{width:40px;height:40px;border-radius:50%;background:var(--whatsapp-green);color:#fff;border:none;margin-left:10px;cursor:pointer}

/* ==== MOBILE (<=576px) ==== */
@media (max-width:576px){
  .brand-img{height:22px}
  .brand-text{max-width:54vw;font-size:13.5px}
  .navbar-toggler{padding:.2rem .45rem}

  .search-wrap{padding:1rem 0}
  .search-wrap h4{font-size:1.05rem;margin-bottom:.6rem}
  .search-wrap .row>[class*="col-"]{padding-left:6px;padding-right:6px}
  .search-wrap .form-label{font-size:.85rem;margin-bottom:.25rem}
  .search-wrap .form-select,.search-wrap .form-control{height:36px;font-size:.95rem;border-radius:8px}
  .btn-theme{padding:.48rem .8rem}

  .hero{min-height:36vh;background-attachment:scroll}
  .section{padding:1.8rem 0}
  .prop-img-wrap{height:170px}

  .whatsapp-chat-container{bottom:12px;right:12px}
  .chat-button{width:46px;height:46px;font-size:22px}
  .notification-badge{width:16px;height:16px;font-size:9px}
  .chat-tooltip{display:none}
}
</style>

</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark navbar-premium sticky-top">
  <div class="container">
    <a class="navbar-brand d-flex align-items-center gap-2" href="#inicio">
      <img src="img/faviconcin3.png" class="brand-img" alt="Logo">
      <span class="brand-text">Lagar Servicios Inmobiliarios</span>
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav" aria-expanded="false" aria-label="Abrir menú">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div id="nav" class="collapse navbar-collapse">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link" href="#inicio">Inicio</a></li>
        <li class="nav-item"><a class="nav-link" href="#galeria">Propiedades</a></li>
        <li class="nav-item"><a class="nav-link" href="#quienessomos">Quiénes somos</a></li>
        <li class="nav-item"><a class="nav-link" href="#equipo">Equipo</a></li>
        <li class="nav-item"><a class="nav-link" href="#servicios-contables">Servicios Contables</a></li>
        <li class="nav-item"><a class="nav-link" href="#tasacion">Tasación</a></li>
      </ul>
    </div>
  </div>
</nav>

<!-- Buscador -->
<div class="search-wrap">
  <div class="container">
    <h4 class="mb-3 fw-semibold">Encontrá tu propiedad ideal</h4>
    <form action="index.php" method="get" class="row g-2 align-items-end">
      <div class="col-6 col-md-3">
        <label class="form-label">Localidad</label>
        <select name="localidad" id="localidad" class="form-select" onchange="cargarBarrios()">
          <option value="">Todas</option>
          <?php foreach ($localidades as $loc): ?>
            <option value="<?= htmlspecialchars($loc['localidad']) ?>" <?= $localidad === $loc['localidad'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($loc['localidad']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-6 col-md-3">
        <label class="form-label">Barrio</label>
        <select name="barrio" id="barrio" class="form-select" disabled>
          <option value="">Todos</option>
        </select>
      </div>
      <div class="col-6 col-md-2">
        <label class="form-label">Operación</label>
        <select name="operacion" class="form-select">
          <option value="">Todas</option>
          <option value="Comprar" <?= $operacion === 'Comprar' ? 'selected' : '' ?>>Comprar</option>
          <option value="Alquilar" <?= $operacion === 'Alquilar' ? 'selected' : '' ?>>Alquilar</option>
        </select>
      </div>
      <div class="col-6 col-md-2">
        <label class="form-label">Tipo</label>
        <select name="tipo" class="form-select">
          <option value="">Todos</option>
          <?php foreach (['Casa','Departamento','PH','Lote','Galpón','Garage','Oficina'] as $t): ?>
            <option value="<?= $t ?>" <?= $tipo === $t ? 'selected' : '' ?>><?= $t ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-6 col-md-1">
        <label class="form-label">Amb.</label>
        <select name="ambientes" class="form-select">
          <option value="">--</option>
          <?php for ($i=1;$i<=4;$i++): ?>
            <option value="<?= $i ?>" <?= $ambientes === (string)$i ? 'selected' : '' ?>><?= $i ?></option>
          <?php endfor; ?>
        </select>
      </div>
      <div class="col-6 col-md-1 d-grid">
        <button type="submit" class="btn btn-theme"><i class="bi bi-search"></i></button>
      </div>
    </form>
  </div>
</div>

<script>
function cargarBarrios() {
  const locSel = document.getElementById('localidad');
  const barrioSel = document.getElementById('barrio');
  const loc = locSel.value;
  barrioSel.innerHTML = '<option value="">Todos</option>';
  barrioSel.disabled = true;
  if (!loc) return;
  fetch('ajax_barrios.php?localidad=' + encodeURIComponent(loc))
    .then(r => r.json())
    .then(data => {
      if (Array.isArray(data) && data.length) {
        const seleccionado = <?= json_encode($barrio) ?>;
        data.forEach(function(b){
          const opt = document.createElement('option');
          opt.value = b; opt.textContent = b;
          if (b === seleccionado) opt.selected = true;
          barrioSel.appendChild(opt);
        });
        barrioSel.disabled = false;
      }
    })
    .catch(console.error);
}
document.addEventListener('DOMContentLoaded', cargarBarrios);
</script>

<!-- Hero -->
<section class="hero" id="inicio">
  <div class="hero-inner"></div>
</section>

<!-- Nosotros -->
<!-- Objetivo / Quiénes Somos -->
<section id="quienessomos" class="section">
  <div class="container">
    <div class="row align-items-center g-4">
      
      <!-- Imagen -->
      <div class="col-lg-6">
        <img src="img/img.jpg" alt="Sala de estar moderna" class="img-fluid img-elev rounded shadow">
      </div>
      
      <!-- Texto -->
      <div class="col-lg-6">
        <h2 class="section-title">Nosotros</h2>
        
        <p class="lead-muted">
          En <strong>David Lagar Servicios Inmobiliarios</strong>, somos más que un equipo de expertos en bienes raíces.
          Sabemos que comprar o vender una propiedad es una de las decisiones más importantes de tu vida, 
          y por eso te ofrecemos un enfoque integral con respaldo legal y contable.
        </p>
        
        <p class="lead-muted">
          Te acompañamos en cada paso: desde la negociación hasta la firma del contrato, 
          asegurando que todo se realice de manera segura, transparente y sin sorpresas.
        </p>
        
        <p class="lead-muted">
          Nuestro compromiso es brindarte una experiencia fluida, minimizando riesgos y optimizando beneficios.
          Además, trabajamos con un trato cercano y personalizado, guiándote hacia la propiedad perfecta.
        </p>
        
        <p class="lead-muted mb-4">
          Desde terrenos y departamentos hasta casas en zonas exclusivas, tenemos la opción que se ajusta a tu estilo de vida, presupuesto y necesidades.
        </p>
        
        <a href="#tasacion" class="btn btn-outline-theme">Tasá tu propiedad</a>
      </div>
      
    </div>
  </div>
</section>


<!-- Beneficios -->
<section class="section" style="background:#fff">
  <div class="container">
    <div class="text-center mb-4">
      <h2 class="section-title">¿Por qué elegirnos?</h2>
      <p class="lead-muted mx-auto" style="max-width:720px">Soluciones integrales con foco en calidad, claridad y resultados.</p>
    </div>
    <div class="row g-3">
      <div class="col-md-4"><div class="prop-card h-100 text-center p-4"><i class="bi bi-shop-window display-6 mb-2 text-primary"></i><h5 class="fw-bold">Proyectos exclusivos</h5><p class="lead-muted mb-0">Selección curada.</p></div></div>
      <div class="col-md-4"><div class="prop-card h-100 text-center p-4"><i class="bi bi-globe display-6 mb-2 text-primary"></i><h5 class="fw-bold">Cobertura</h5><p class="lead-muted mb-0">Ubicaciones clave.</p></div></div>
      <div class="col-md-4"><div class="prop-card h-100 text-center p-4"><i class="bi bi-graph-up-arrow display-6 mb-2 text-primary"></i><h5 class="fw-bold">Oportunidades</h5><p class="lead-muted mb-0">Condiciones competitivas.</p></div></div>
    </div>
  </div>
</section>

<!-- Galería -->
<section class="section" style="background:var(--bg)" id="galeria">
  <div class="container">
    <div class="text-center mb-3">
      <h2 class="section-title">Propiedades destacadas</h2>
      <p class="lead-muted mx-auto" style="max-width:720px">Explorá nuestra selección.</p>
    </div>
    <div class="filter-chips">
      <button class="chip active" data-cat="all">Todas</button>
      <button class="chip" data-cat="Casa">Casas</button>
      <button class="chip" data-cat="Departamento">Departamentos</button>
      <button class="chip" data-cat="Oficina">Oficinas</button>
    </div>
    <div class="row">
      <?php while($g = $gal->fetch_assoc()): ?>
        <div class="col-lg-4 col-md-6 mb-4 filtro" data-cat="<?= htmlspecialchars($g['tipo']) ?>">
          <div class="prop-card">
            <div class="prop-img-wrap">
              <img src="uploads/<?= htmlspecialchars($g['imagen']) ?>" alt="<?= htmlspecialchars($g['titulo']) ?>" class="prop-img">
              <span class="prop-type"><?= htmlspecialchars($g['tipo']) ?></span>
            </div>
            <div class="prop-body">
              <h3 class="prop-title"><?= htmlspecialchars($g['titulo']) ?></h3>
              <a class="prop-link" href="propiedad.php?id=<?= (int)$g['id'] ?>">Ver detalles <i class="bi bi-arrow-right"></i></a>
            </div>
          </div>
        </div>
      <?php endwhile; ?>
    </div>
    <div class="text-center mt-2">
      <a href="buscador.php" class="btn btn-theme">Ver todas</a>
    </div>
  </div>
</section>

<!-- Equipo -->
<section class="section" id="equipo" style="background:var(--bg)">
  <div class="container">
    <div class="row g-4 align-items-center">
      <!-- Imagen -->
      <div class="col-lg-5">
        <div class="img-cover" style="background-image:url('img/equipo.jpeg')"></div>
      </div>

      <!-- Contenido -->
      <div class="col-lg-7">
        <h2 class="section-title">Equipo</h2>
        <p class="lead">
          Somos un equipo de jóvenes profesionales nacidos y formados en esta región, 
          profundamente comprometidos con la confianza que cada cliente deposita en nosotros.  
          Nuestro trabajo se basa en la exclusividad, la transparencia y el acompañamiento personalizado 
          durante todo el proceso, asegurando que cada operación se realice con la máxima seguridad y tranquilidad.
        </p>
        <p class="lead-muted">
          Cada cliente que nos elige se convierte en el centro de nuestra atención, porque sabemos que detrás de cada proyecto hay sueños, objetivos y expectativas únicas.  
          Gracias por permitirnos ser parte de su camino y por confiar en nosotros para hacerlo realidad.
        </p>

        <!-- Ítems destacados -->
        <div class="row g-3 mt-3">
          <div class="col-md-6">
            <div class="cta-pane h-100">
              <h6 class="fw-bold mb-2">
                <i class="bi bi-person-badge me-1"></i> Atención personalizada
              </h6>
              <p class="mb-0 lead-muted">De la tasación al boleto.</p>
            </div>
          </div>
          <div class="col-md-6">
            <div class="cta-pane h-100">
              <h6 class="fw-bold mb-2">
                <i class="bi bi-briefcase me-1"></i> Experiencia & confianza
              </h6>
              <p class="mb-0 lead-muted">Asesoramiento legal y contable.</p>
            </div>
          </div>
        </div>
      </div>
      <!-- Fin contenido -->
    </div>
  </div>
</section>

<!-- Servicios Contables -->
<section class="section" id="servicios-contables">
  <div class="container">
    <div class="row g-4 align-items-center">
      <!-- Imagen -->
      <div class="col-lg-7 order-lg-2">
        <div class="img-cover" style="background-image:url('https://lagarpropiedades.com/img/sc.png')"></div>
      </div>

      <!-- Contenido -->
      <div class="col-lg-5 order-lg-1">
        <h2 class="section-title">Servicios Contables</h2>
        <p class="lead fw-bold mb-1">Mayra Paredes – Contadora Pública Matriculada (UBA)</p>
        <p class="lead-muted">
          Brinda asesoría fiscal, contable, laboral y en habilitaciones comerciales para monotributistas 
          y responsables inscriptos. Enfoque personalizado para que tu negocio crezca cumpliendo con la ley.
        </p>

        <ul class="lead-muted mt-3">
          <li>Liquidación de impuestos, planificación fiscal y cumplimiento normativo.</li>
          <li>Administración de consorcios con gestión financiera clara y eficiente.</li>
          <li>Asesoría laboral: sueldos, cargas sociales y legislación vigente.</li>
          <li>Habilitaciones comerciales completas: desde asesoramiento hasta obtención del certificado.</li>
        </ul>

        <!-- Contacto -->
        <div class="mt-3">
          <p class="mb-1"><i class="bi bi-telephone me-1"></i> 📞 2257-528166</p>
          <p class="mb-0"><i class="bi bi-envelope me-1"></i> 📧 <a href="mailto:mayraparedesv@gmail.com">mayraparedesv@gmail.com</a></p>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- Tasación -->
<section class="section" id="tasacion" style="background:var(--bg)">
  <div class="container">
    <div class="row g-4">
      <div class="col-lg-6">
        <h2 class="section-title">Tasación</h2>
        <p class="lead-muted">Completá el formulario y coordinamos una visita.</p>

        <form class="cta-pane" action="enviar_tasacion.php" method="post">
          <input type="hidden" name="asunto" value="Consulta de Tasación (home)">
          <input type="hidden" name="origen"  value="index#tasacion">
          <div class="mb-3">
            <label class="form-label">Nombre y apellido*</label>
            <input type="text" name="nombre" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Teléfono</label>
            <input type="text" name="telefono" class="form-control">
          </div>
          <div class="mb-3">
            <label class="form-label">Mensaje*</label>
            <textarea name="mensaje" class="form-control" rows="5" placeholder="Dirección, tipo de propiedad, estado general..." required></textarea>
          </div>
          <button type="submit" class="btn btn-theme"><i class="bi bi-send"></i> Enviar consulta</button>
        </form>
      </div>
      <div class="col-lg-6">
        <div class="cta-pane h-100 d-flex flex-column justify-content-center">
          <h5 class="fw-bold"><i class="bi bi-info-circle me-1"></i> ¿Qué evaluamos?</h5>
          <ul class="mb-0 lead-muted">
            <li>Ubicación, m² y orientación</li>
            <li>Estado y antigüedad</li>
            <li>Comparables de mercado</li>
          </ul>
          <div class="mt-3">
            <span class="badge text-bg-light border me-2">Sin costo</span>
            <span class="badge text-bg-light border">Respuesta rápida</span>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ===== Footer ===== -->
<footer class="site-footer mt-5">
  <div class="container py-5">
    <div class="row gy-4">
      <div class="col-md-4">
        <a href="#inicio" class="footer-brand d-flex align-items-center gap-2 mb-3 text-decoration-none">
          <img src="img/faviconcin3.png" alt="Logo" class="footer-logo">
          <span class="fw-bold">Lagar Servicios Inmobiliarios</span>
        </a>
        <p class="footer-text mb-3">Asesoramiento integral en compra, venta y alquiler.</p>
        <div class="d-flex gap-3 fs-5">
          <a class="footer-social bi bi-whatsapp"  href="https://wa.me/5491154571436" target="_blank" aria-label="WhatsApp"></a>
          <a class="footer-social bi bi-instagram" href="https://instagram.com/" target="_blank" aria-label="Instagram"></a>
          <a class="footer-social bi bi-facebook"  href="https://facebook.com/"  target="_blank" aria-label="Facebook"></a>
          <a class="footer-social bi bi-envelope"  href="mailto:lagarpropiedades@gmail.com"    aria-label="Email"></a>
        </div>
      </div>

      <div class="col-6 col-md-2">
        <h6 class="footer-title">Explorar</h6>
        <ul class="list-unstyled mb-0">
          <li><a class="footer-link" href="#galeria">Propiedades</a></li>
          <li><a class="footer-link" href="#equipo">Equipo</a></li>
          <li><a class="footer-link" href="#servicios-contables">Servicios Contables</a></li>
          <li><a class="footer-link" href="#tasacion">Tasación</a></li>
          <li><a class="footer-link" href="buscador.php">Buscador</a></li>
        </ul>
      </div>

      <div class="col-6 col-md-3">
        <h6 class="footer-title">Contacto</h6>
        <ul class="list-unstyled footer-text mb-0">
          <li class="mb-1"><i class="bi bi-geo-alt me-2"></i>Tu dirección, Ciudad</li>
          <li class="mb-1"><i class="bi bi-telephone me-2"></i><a class="footer-link" href="tel:+5491154571436">+54 9 11 5457-1436</a></li>
          <li class="mb-1"><i class="bi bi-envelope me-2"></i><a class="footer-link" href="mailto:lagarpropiedades@gmail.com">lagarpropiedades@gmail.com</a></li>
          <li class="mb-1"><i class="bi bi-clock me-2"></i>Lun a Vie 9–18 h</li>
        </ul>
      </div>

      <div class="col-md-3">
        <div class="footer-cta p-3">
          <h6 class="mb-2 fw-bold">¿Querés tasar tu propiedad?</h6>
          <p class="footer-text mb-3">Respondemos rápido y sin costo.</p>
          <a href="#tasacion" class="btn btn-sm btn-theme w-100">Solicitar tasación</a>
        </div>
      </div>
    </div>

    <hr class="footer-sep my-4">

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center gap-3 small">
      <div class="text-secondary">
        © <?= date('Y'); ?> Lagar Servicios Inmobiliarios. Todos los derechos reservados.
      </div>
      <div class="d-flex gap-3">
        <a href="#inicio" class="footer-link">Volver arriba ↑</a>
      </div>
    </div>
    <small class="text-white-50">Diseño y desarrollo por <a href="https://netfan.host" class="text-white">NETFAN</a></small>
  </div>
</footer>

<!-- Modal de Resultados -->
<?php if ($mostrarModal): ?>
<div class="modal fade" id="resultModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Resultados de la búsqueda (<?= $resultados ? $resultados->num_rows : 0 ?>)</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <?php if ($resultados && $resultados->num_rows): ?>
          <div class="list-group">
            <?php while ($r = $resultados->fetch_assoc()): ?>
              <a href="propiedad.php?id=<?= (int)$r['id'] ?>" class="list-group-item list-group-item-action py-2">
                <div class="d-flex align-items-center gap-3">
                  <img src="uploads/<?= htmlspecialchars($r['imagen']) ?>" alt="<?= htmlspecialchars($r['titulo']) ?>" class="list-thumb">
                  <div class="flex-grow-1 fw-semibold"><?= htmlspecialchars($r['titulo']) ?></div>
                  <span class="badge text-bg-light border"><?= htmlspecialchars($r['tipo']) ?></span>
                </div>
              </a>
            <?php endwhile; ?>
          </div>
        <?php else: ?>
          <p class="mb-0">No se encontraron propiedades que coincidan.</p>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<script>
document.addEventListener('DOMContentLoaded',()=>{ const el=document.getElementById('resultModal'); if(el) new bootstrap.Modal(el).show(); });
</script>
<?php endif; ?>

<!-- WhatsApp Chat -->
<div class="whatsapp-chat-container">
  <div class="whatsapp-closed">
    <div class="chat-tooltip">
      <div class="chat-header">
        <img src="https://cdn-icons-png.flaticon.com/512/124/124034.png" alt="WhatsApp" class="chat-avatar">
        <div class="chat-info">
          <strong>Lagar Servicios Inmobiliarios</strong>
          <small>En línea ahora</small>
        </div>
      </div>
      <div class="chat-preview">¡Hola! ¿En qué podemos ayudarte hoy?</div>
    </div>
    <a class="chat-button" href="https://wa.me/5491154571436" target="_blank" aria-label="WhatsApp">
      <i class="fab fa-whatsapp"></i>
      <div class="notification-badge">1</div>
    </a>
  </div>

  <div class="whatsapp-open">
    <div class="chat-header">
      <img src="https://cdn-icons-png.flaticon.com/512/124/124034.png" alt="WhatsApp" class="chat-avatar">
      <div class="chat-info"><strong>Lagar Servicios Inmobiliarios</strong><small>En línea ahora</small></div>
      <button class="close-chat"><i class="fas fa-times"></i></button>
    </div>
    <div class="chat-messages">
      <div class="message received">
        <div class="message-content">¡Hola! ¿En qué podemos ayudarte?</div>
      </div>
    </div>
    <div class="chat-input">
      <input type="text" placeholder="Escribe un mensaje...">
      <button class="send-button"><i class="fab fa-whatsapp"></i></button>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
/* Filtro de propiedades (chips) */
document.querySelectorAll('.chip').forEach(btn=>{
  btn.addEventListener('click',()=>{
    document.querySelectorAll('.chip').forEach(b=>b.classList.remove('active'));
    btn.classList.add('active');
    const cat=btn.dataset.cat;
    document.querySelectorAll('.filtro').forEach(el=>{
      const show=(cat==='all'||el.dataset.cat===cat);
      el.style.display=show?'block':'none';
      el.style.opacity=show?'1':'0';
      el.style.transform=show?'translateY(0)':'translateY(12px)';
    });
  });
});

/* WhatsApp: abre simulador y luego va a wa.me */
(function () {
  const container = document.querySelector('.whatsapp-chat-container');
  if (!container) return;
  const btnOpen  = container.querySelector('.chat-button');
  const btnClose = container.querySelector('.close-chat');
  const input    = container.querySelector('.chat-input input');
  const btnSend  = container.querySelector('.send-button');

  function getWhatsAppNumber() {
    const href = (btnOpen && btnOpen.getAttribute('href')) || '';
    const m = href.match(/wa\.me\/(\d+)/);
    return m ? m[1] : null;
  }
  function goToWhatsApp() {
    const number = getWhatsAppNumber();
    if (!number) return;
    const text = (input && input.value.trim()) || 'Hola, quiero más información 👋';
    const url = `https://wa.me/${number}?text=${encodeURIComponent(text)}`;
    window.location.href = url;
  }
  if (btnOpen) btnOpen.addEventListener('click',(e)=>{ e.preventDefault(); container.classList.add('chat-visible'); input && input.focus(); });
  if (btnClose) btnClose.addEventListener('click',()=> container.classList.remove('chat-visible'));
  if (btnSend)  btnSend.addEventListener('click',(e)=>{ e.preventDefault(); goToWhatsApp(); });
  if (input)    input.addEventListener('keydown',(e)=>{ if (e.key==='Enter'){ e.preventDefault(); goToWhatsApp(); } });
})();

/* Hero: carrusel con imágenes a pantalla completa (cover) */
(function(){
  // Usá los nombres y extensiones reales de tus archivos
  const HERO_IMAGES = [
    'img/c1.jpg',
    'img/c2.jpg',
    'img/c3.jpg'
  ];
  const ROTATION_MS = 5000;

  if (!HERO_IMAGES.length) return;

  document.querySelectorAll('.hero').forEach(hero=>{
    // pista
    let wrap = hero.querySelector('.hero__slides');
    if(!wrap){
      wrap = document.createElement('div');
      wrap.className = 'hero__slides';
      hero.prepend(wrap);
    }

    // slides con <img> (object-fit evita cualquier estirado)
    const slides = HERO_IMAGES.map((src, i)=>{
      const slide = document.createElement('div');
      slide.className = 'hero__slide' + (i===0 ? ' is-active' : '');

      const img = document.createElement('img');
      img.className = 'hero__img';
      img.src = src;
      img.alt = '';

      slide.appendChild(img);
      wrap.appendChild(slide);

      // preload
      const pre = new Image(); pre.src = src;
      return slide;
    });

    if (slides.length < 2) return;

    let idx = 0;
    setInterval(()=>{
      slides[idx].classList.remove('is-active');
      idx = (idx + 1) % slides.length;
      slides[idx].classList.add('is-active');
    }, ROTATION_MS);
  });
})();
</script>
<!-- === FLOTANTES REDES (rediseñados) === -->
<div class="social-float" aria-label="Redes sociales">
  <a href="https://www.instagram.com/lagar.propiedades/" class="social-btn ig" target="_blank" rel="noopener" aria-label="Ir a Instagram">
    <svg viewBox="0 0 24 24" aria-hidden="true">
      <path d="M12 2c2.717 0 3.056.01 4.122.06 1.065.05 1.79.217 2.428.465.66.254 1.216.598 1.772 1.153a4.908 4.908 0 0 1 1.153 1.772c.247.637.415 1.363.465 2.428.047 1.066.06 1.405.06 4.122 0 2.717-.01 3.056-.06 4.122-.05 1.065-.218 1.79-.465 2.428a4.883 4.883 0 0 1-1.153 1.772 4.915 4.915 0 0 1-1.772 1.153c-.637.247-1.363.415-2.428.465-1.066.047-1.405.06-4.122.06-2.717 0-3.056-.01-4.122-.06-1.065-.05-1.79-.218-2.428-.465a4.89 4.89 0 0 1-1.772-1.153 4.904 4.904 0 0 1-1.153-1.772c-.248-.637-.415-1.363-.465-2.428C2.013 15.056 2 14.717 2 12c0-2.717.01-3.056.06-4.122.05-1.066.217-1.79.465-2.428a4.88 4.88 0 0 1 1.153-1.772A4.897 4.897 0 0 1 5.45 2.525c.638-.248 1.362-.415 2.428-.465C8.944 2.013 9.283 2 12 2zm0 5a5 5 0 1 0 0 10 5 5 0 0 0 0-10zm6.5-.25a1.25 1.25 0 0 0-2.5 0 1.25 1.25 0 0 0 2.5 0zM12 9a3 3 0 1 1 0 6 3 3 0 0 1 0-6z"/>
    </svg>
  </a>

  <a href="https://www.facebook.com/lacostaalquilo/" class="social-btn fb" target="_blank" rel="noopener" aria-label="Ir a Facebook">
    <svg viewBox="0 0 24 24" aria-hidden="true">
      <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
    </svg>
  </a>
</div>

<style>
  .social-float {
    position: fixed;
    left: 20px;
    bottom: max(20px, env(safe-area-inset-bottom));
    display: flex;
    flex-direction: column;
    gap: 16px;
    z-index: 9999;
  }
  
  .social-btn {
    --size: 60px;
    width: var(--size);
    height: var(--size);
    border-radius: 50%;
    display: grid;
    place-items: center;
    color: #fff;
    text-decoration: none;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
    position: relative;
    overflow: hidden;
    border: none;
  }
  
  .social-btn:before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.1);
    transform: translateY(100%);
    transition: transform 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
    border-radius: 50%;
  }
  
  .social-btn:hover {
    transform: translateY(-5px) scale(1.05);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
  }
  
  .social-btn:hover:before {
    transform: translateY(0);
  }
  
  .social-btn svg {
    width: 28px;
    height: 28px;
    position: relative;
    z-index: 1;
    transition: transform 0.3s ease;
  }
  
  .social-btn:hover svg {
    transform: scale(1.15);
  }
  
  /* Instagram con gradiente mejorado y efecto de luz */
  .social-btn.ig {
    background: linear-gradient(45deg, 
      #f09433 0%, 
      #e6683c 25%, 
      #dc2743 50%, 
      #cc2366 75%, 
      #bc1888 100%);
  }
  
  .social-btn.ig:after {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle at center, 
                rgba(255, 255, 255, 0.4) 0%, 
                rgba(255, 255, 255, 0) 60%);
    opacity: 0;
    transition: opacity 0.3s ease;
  }
  
  .social-btn.ig:hover:after {
    opacity: 1;
  }
  
  /* Facebook con gradiente en lugar de color plano */
  .social-btn.fb {
    background: linear-gradient(45deg, #1877F2, #0D6EFD);
  }
  
  /* Efecto de pulso al hacer hover */
  @keyframes pulse {
    0% { box-shadow: 0 0 0 0 rgba(0, 0, 0, 0.2); }
    70% { box-shadow: 0 0 0 10px rgba(0, 0, 0, 0); }
    100% { box-shadow: 0 0 0 0 rgba(0, 0, 0, 0); }
  }
  
  .social-btn:hover {
    animation: pulse 1.5s infinite;
  }
  
  /* Móviles */
  @media (max-width: 768px) {
    .social-float {
      left: 15px;
      bottom: max(15px, env(safe-area-inset-bottom));
      gap: 12px;
    }
    
    .social-btn {
      --size: 54px;
    }
    
    .social-btn svg {
      width: 24px;
      height: 24px;
    }
  }
  
  /* Tablets */
  @media (max-width: 1024px) and (min-width: 769px) {
    .social-btn {
      --size: 58px;
    }
  }
</style>
<!-- === /FLOTANTES REDES === -->
</body>
</html>
