<?php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$id = intval($_GET['id'] ?? 0);
$autoPrint = isset($_GET['print']);

if ($id <= 0) {
  echo "❌ ID inválido.";
  exit;
}

$sql = "SELECT * FROM caja_mesa WHERE id = $id LIMIT 1";
$res = mysqli_query($con, $sql);
if (!$res || mysqli_num_rows($res) == 0) {
  echo "❌ Ticket no encontrado.";
  exit;
}

$ticket = mysqli_fetch_assoc($res);
$detalles = json_decode($ticket['detalles_json'] ?? '{}', true);
$productos = $detalles['productos'] ?? [];
$descuento = $detalles['descuento'] ?? 0;
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ticket Mesa #<?= $ticket['id'] ?></title>
  <style>
    body {
      font-family: monospace;
      font-size: 14px;
      padding: 10px;
      max-width: 300px;
      margin: auto;
    }
    h2 {
      text-align: center;
    }
    .linea {
      border-top: 1px dashed #000;
      margin: 8px 0;
    }
    .totales {
      margin-top: 10px;
    }
    .btns {
      margin-top: 20px;
      display: flex;
      justify-content: space-between;
    }
    @media print {
      .btns { display: none; }
    }
  </style>
</head>
<body>

<h2>🍽 Ticket Mesa</h2>
Mesa: <?= htmlspecialchars($ticket['mesa_id']) ?><br>
Fecha: <?= htmlspecialchars($ticket['fecha']) ?><br>
Hora: <?= htmlspecialchars($ticket['hora']) ?><br>
Cliente: <?= htmlspecialchars($ticket['cliente'] ?: '-') ?><br>
Comentario: <?= htmlspecialchars($ticket['comentario'] ?: '-') ?>

<div class="linea"></div>

<b>Productos:</b><br>
<?php if (count($productos) > 0): ?>
  <ul>
    <?php foreach ($productos as $p): ?>
      <?php
        $nombre = htmlspecialchars($p['nombre'] ?? 'Producto');
        $precio = floatval($p['precio'] ?? 0);
        $cantidad = intval($p['cantidad'] ?? 1);
        $subtotal = $precio * $cantidad;
      ?>
      <li><?= $nombre ?> x<?= $cantidad ?> - $<?= number_format($subtotal, 2) ?></li>
    <?php endforeach; ?>
  </ul>
<?php else: ?>
  <i>Sin detalle</i><br>
<?php endif; ?>

<?php if ($descuento > 0): ?>
  <b>Descuento:</b> <?= number_format($descuento, 2) ?>%<br>
<?php endif; ?>

<div class="linea"></div>

<div class="totales">
  <b>Total:</b> $<?= number_format($ticket['monto_total'], 2) ?><br>
  <b>Forma de pago:</b> <?= ucfirst($ticket['forma_pago']) ?><br>
  <?php if ($ticket['forma_pago'] === 'dividido'): ?>
    💵 Efectivo: $<?= number_format($ticket['efectivo'], 2) ?><br>
    💳 Transferencia: $<?= number_format($ticket['transferencia'], 2) ?><br>
  <?php endif; ?>
</div>

<div class="btns">
  <button onclick="window.print()">🖨 Imprimir</button>
  <a href="index.php">🔙 Volver</a>
</div>

<?php if ($autoPrint): ?>
<script>window.onload = () => window.print();</script>
<?php endif; ?>

</body>
</html>
