<?php
require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// Agregar mesa
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['accion'] === 'agregar') {
  $numero = intval($_POST['numero']);
  $nombre = trim($_POST['nombre']);
  $ubicacion = trim($_POST['ubicacion']);
  if ($numero > 0 && $nombre !== '') {
    $stmt = mysqli_prepare($con, "INSERT INTO mesas (numero, nombre, ubicacion, en_index) VALUES (?, ?, ?, 1)");
    mysqli_stmt_bind_param($stmt, 'iss', $numero, $nombre, $ubicacion);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
  }
  header("Location: admin_mesas.php");
  exit;
}

// Editar mesa
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['accion'] === 'editar') {
  $id = intval($_POST['id']);
  $numero = intval($_POST['numero']);
  $nombre = trim($_POST['nombre']);
  $ubicacion = trim($_POST['ubicacion']);
  $en_index = isset($_POST['en_index']) ? 1 : 0;
  if ($id > 0 && $numero > 0 && $nombre !== '') {
    $stmt = mysqli_prepare($con, "UPDATE mesas SET numero = ?, nombre = ?, ubicacion = ?, en_index = ? WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'issii', $numero, $nombre, $ubicacion, $en_index, $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
  }
  header("Location: admin_mesas.php");
  exit;
}

// Borrar mesa
if (isset($_GET['borrar']) && is_numeric($_GET['borrar'])) {
  $id = intval($_GET['borrar']);
  mysqli_query($con, "DELETE FROM mesas WHERE id = $id LIMIT 1");
  header("Location: admin_mesas.php");
  exit;
}

// Obtener mesas
$res = mysqli_query($con, "SELECT * FROM mesas ORDER BY numero ASC");
$mesas = mysqli_fetch_all($res, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Administrar Mesas</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .tachito { color: #dc3545; text-decoration: none; font-size: 1.2em; }
    .tachito:hover { color: #a00; }
    .editar-btn { font-size: 0.9em; }
  </style>
</head>
<body class="bg-light">
<div class="container py-4">
  <h2 class="mb-4">🪑 Administrar Mesas</h2>

  <form method="POST" class="row g-3 mb-4">
    <input type="hidden" name="accion" value="agregar">
    <div class="col-md-2">
      <input type="number" name="numero" class="form-control" placeholder="N° Mesa" required>
    </div>
    <div class="col-md-4">
      <input type="text" name="nombre" class="form-control" placeholder="Nombre" required>
    </div>
    <div class="col-md-4">
      <input type="text" name="ubicacion" class="form-control" placeholder="Ubicación">
    </div>
    <div class="col-md-2">
      <button type="submit" class="btn btn-success w-100">Agregar</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-bordered table-sm bg-white align-middle">
      <thead class="table-light">
        <tr><th>ID</th><th>N°</th><th>Nombre</th><th>Ubicación</th><th>Index</th><th style="width: 120px;">Acciones</th></tr>
      </thead>
      <tbody>
        <?php foreach ($mesas as $m): ?>
          <tr>
            <form method="POST">
              <input type="hidden" name="accion" value="editar">
              <input type="hidden" name="id" value="<?= $m['id'] ?>">
              <td><?= $m['id'] ?></td>
              <td><input type="number" name="numero" class="form-control form-control-sm" value="<?= $m['numero'] ?>" required></td>
              <td><input type="text" name="nombre" class="form-control form-control-sm" value="<?= htmlspecialchars($m['nombre']) ?>" required></td>
              <td><input type="text" name="ubicacion" class="form-control form-control-sm" value="<?= htmlspecialchars($m['ubicacion']) ?>"></td>
              <td class="text-center">
                <input type="checkbox" name="en_index" value="1" <?= $m['en_index'] ? 'checked' : '' ?>>
              </td>
              <td>
                <button type="submit" class="btn btn-sm btn-primary editar-btn">💾</button>
                <a href="?borrar=<?= $m['id'] ?>" class="tachito ms-2" onclick="return confirm('¿Eliminar esta mesa?')">🗑️</a>
              </td>
            </form>
          </tr>
        <?php endforeach; ?>
        <?php if (count($mesas) === 0): ?>
          <tr><td colspan="6" class="text-center text-muted">No hay mesas cargadas.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
