<?php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

if (!isset($_POST['sala_id'], $_POST['total'], $_POST['forma_pago'])) {
    http_response_code(400);
    echo 'Datos incompletos';
    exit;
}

$sala_id      = intval($_POST['sala_id']);
$total        = floatval($_POST['total']);
$forma_pago   = $_POST['forma_pago'];
$efectivo     = isset($_POST['efectivo']) ? floatval($_POST['efectivo']) : 0;
$transferencia= isset($_POST['transferencia']) ? floatval($_POST['transferencia']) : 0;
$cliente      = isset($_POST['cliente']) ? trim($_POST['cliente']) : '';
$comentario   = isset($_POST['comentario']) ? trim($_POST['comentario']) : '';

$fecha = date('Y-m-d');
$hora  = date('H:i:s');

$ticket_html = '
  <div style="font-family: Arial, sans-serif; max-width: 300px;">
    <h3>🎟️ Ticket de Sala</h3>
    <p><strong>Fecha:</strong> ' . $fecha . ' ' . $hora . '</p>
    <p><strong>Sala ID:</strong> ' . $sala_id . '</p>
    <p><strong>Cliente:</strong> ' . htmlspecialchars($cliente) . '</p>
    <hr>
    <p><strong>Total:</strong> $' . number_format($total, 2, '.', '') . '</p>
    <p><strong>Forma de Pago:</strong> ' . ucfirst($forma_pago) . '</p>
    <p>Efectivo: $' . number_format($efectivo, 2, '.', '') . '</p>
    <p>Transferencia: $' . number_format($transferencia, 2, '.', '') . '</p>
    <hr>
    <p style="font-size: 12px;">Gracias por su visita.</p>
  </div>
';

$sql = "INSERT INTO caja_sala (sala_id, fecha, hora, total, efectivo, transferencia, forma_pago, cliente, comentario, ticket_html)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = mysqli_prepare($con, $sql);
mysqli_stmt_bind_param($stmt, "issddsssss", $sala_id, $fecha, $hora, $total, $efectivo, $transferencia, $forma_pago, $cliente, $comentario, $ticket_html);
$ok = mysqli_stmt_execute($stmt);

if ($ok) {
    echo $con->insert_id; // ✅ devuelve el ID para poder imprimir luego
} else {
    http_response_code(500);
    echo "❌ Error al guardar";
}
?>
