<?php
// ajax/guardar_cobro_mesa.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$mesa_id       = intval($_POST['mesa_id'] ?? 0);
$monto         = floatval($_POST['monto'] ?? 0);
$cliente       = trim($_POST['cliente'] ?? '');
$comentario    = trim($_POST['comentario'] ?? '');
$forma_pago    = $_POST['forma_pago'] ?? '';
$efectivo      = floatval($_POST['efectivo'] ?? 0);
$transferencia = floatval($_POST['transferencia'] ?? 0);
$descuento     = floatval($_POST['descuento'] ?? 0);

$productos_json = $_POST['productos_json'] ?? ($_POST['productos'] ?? '[]');
$productos      = json_decode($productos_json, true);

if ($mesa_id <= 0 || $monto <= 0 || !in_array($forma_pago, ['efectivo','transferencia','dividido'])) {
  echo json_encode(['error' => 'Datos inválidos']);
  exit;
}

$fecha = date('Y-m-d');
$hora  = date('H:i:s');

// 1. Registrar en caja_mesa
$stmt = $con->prepare("INSERT INTO caja_mesa
  (mesa_id, cliente, comentario, monto_total, efectivo, transferencia, forma_pago, fecha, hora)
  VALUES (?,?,?,?,?,?,?,?,?)");
if(!$stmt){ echo json_encode(['error'=>$con->error]); exit; }
$stmt->bind_param("issdddsss", $mesa_id, $cliente, $comentario, $monto, $efectivo, $transferencia, $forma_pago, $fecha, $hora);
$stmt->execute();
$caja_id = $stmt->insert_id;
$stmt->close();

// 2. Registrar ticket principal
$stmt2 = $con->prepare("INSERT INTO tickets_mesa
  (mesa_id, cliente, comentario, total, efectivo, transferencia, forma_pago, descuento, fecha)
  VALUES (?,?,?,?,?,?,?, ?, NOW())");
if(!$stmt2){ echo json_encode(['error'=>$con->error]); exit; }
$stmt2->bind_param("issdddsd", $mesa_id, $cliente, $comentario, $monto, $efectivo, $transferencia, $forma_pago, $descuento);
$stmt2->execute();
$ticket_id = $stmt2->insert_id;
$stmt2->close();

// 3. Detalle de productos
if(is_array($productos) && count($productos) > 0){
  $stmt3 = $con->prepare("INSERT INTO tickets_mesa_detalle (ticket_id, producto_id, precio) VALUES (?,?,?)");
  foreach($productos as $p){
    $pid = intval($p['id'] ?? 0);
    $precio = floatval($p['precio'] ?? 0);
    if($pid>0){
      $stmt3->bind_param("iid", $ticket_id, $pid, $precio);
      $stmt3->execute();
    }
  }
  $stmt3->close();
}

echo json_encode(['success'=>true, 'ticket_id'=>$ticket_id]);
?>