<?php
// ajax/guardar_cobro_sala.php
ob_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

/* ---------- Entrada ---------- */
$sala_id       = intval($_POST['sala_id'] ?? 0);
$cliente       = mysqli_real_escape_string($con, $_POST['cliente'] ?? '');
$comentario    = mysqli_real_escape_string($con, $_POST['comentario'] ?? '');

$precio_sala = floatval($_POST['precio_sala'] ?? 0);
$descuento   = floatval($_POST['descuento'] ?? 0);

$productos   = json_decode($_POST['productos_json'] ?? '[]', true);
$alquileres  = json_decode($_POST['alquileres'] ?? '[]', true);

// Calcular total = precio sala + productos + alquileres - descuento
$monto = $precio_sala;
foreach ($productos as $p) {
    $monto += floatval($p['precio'] ?? 0);
}
foreach ($alquileres as $a) {
    $monto += floatval($a['precio'] ?? 0);
}
$monto -= $descuento;
if ($monto < 0) $monto = 0; // por si hay más descuento que total

$forma_pago    = $_POST['forma_pago'] ?? 'efectivo';
$efectivo      = floatval($_POST['efectivo'] ?? 0);
$transferencia = floatval($_POST['transferencia'] ?? 0);

$hora_inicio = trim($_POST['hora_inicio'] ?? '');
$hora_fin_in = trim($_POST['hora_fin'] ?? '');
$duracion    = intval($_POST['duracion'] ?? 0); // minutos

/* ---------- Hora fin ---------- */
if ($hora_fin_in === '' || $hora_fin_in === '23:59') {
    $dtIni = DateTime::createFromFormat('H:i', $hora_inicio);
    if ($dtIni && $duracion > 0) {
        $dtIni->modify("+{$duracion} minutes");
        $hora_fin = $dtIni->format('H:i');
    } else {
        $hora_fin = '';
    }
} else {
    $hora_fin = $hora_fin_in;
}

/* ---------- JSON Detalle ---------- */
$detalles_json = json_encode([
    'hora_inicio' => $hora_inicio,
    'hora_fin'    => $hora_fin,
    'duracion'    => $duracion,
    'precio_sala' => $precio_sala,
    'productos'   => $productos,
    'alquileres'  => $alquileres,
    'descuento'   => $descuento
], JSON_UNESCAPED_UNICODE);

/* ---------- Ticket HTML opcional ---------- */
$ticket_html = "<h3>Ticket Sala</h3>"
             . "<p>Sala: {$sala_id}</p>"
             . "<p>Cliente: {$cliente}</p>"
             . "<p>Total: $" . number_format($monto, 2, ',', '.') . "</p>"
             . "<p>Forma de pago: {$forma_pago}</p>";

/* ---------- Insert ---------- */
$fecha = date('Y-m-d');
$hora  = date('H:i:s');

$stmt = $con->prepare("
    INSERT INTO caja_sala
    (sala_id, fecha, hora, total, efectivo, transferencia,
     forma_pago, cliente, comentario, ticket_html, detalles_json)
    VALUES (?,?,?,?,?,?,?,?,?,?,?)
");
if(!$stmt){
    ob_end_clean();
    echo json_encode(['error'=>$con->error]); exit;
}

$stmt->bind_param(
    'issdddsssss',
    $sala_id, $fecha, $hora,
    $monto, $efectivo, $transferencia,
    $forma_pago, $cliente, $comentario,
    $ticket_html, $detalles_json
);

if(!$stmt->execute()){
    ob_end_clean();
    echo json_encode(['error'=>$stmt->error]); exit;
}
$ticket_id = $stmt->insert_id;
$stmt->close();

/* ---------- Respuesta ---------- */
ob_end_clean();
header('Content-Type: application/json');
echo json_encode(['success'=>true,'ticket_id'=>$ticket_id]);
?>
