<?php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$id = intval($_GET['id'] ?? 0);
$autoPrint = isset($_GET['print']);

if ($id <= 0) {
  echo "❌ ID inválido.";
  exit;
}

// Obtener el ticket desde tickets_mesa
$sql = "SELECT * FROM tickets_mesa WHERE id = $id LIMIT 1";
$res = mysqli_query($con, $sql);
if (!$res || mysqli_num_rows($res) === 0) {
  echo "❌ Ticket no encontrado.";
  exit;
}
$ticket = mysqli_fetch_assoc($res);

// Obtener productos desde tickets_mesa_detalle
$productos = [];
$detalleSql = "SELECT d.producto_id, d.precio,
                      COALESCE(p.nombre, pm.nombre, CONCAT('ID ', d.producto_id)) AS nombre
               FROM tickets_mesa_detalle d
               LEFT JOIN productos p        ON p.id  = d.producto_id
               LEFT JOIN productos_mesas pm ON pm.id = d.producto_id
               WHERE d.ticket_id = $id";
$detalleRes = mysqli_query($con, $detalleSql);
while ($row = mysqli_fetch_assoc($detalleRes)) {
  $productos[] = [
    'id'       => intval($row['producto_id']),
    'nombre'   => $row['nombre'],
    'precio'   => floatval($row['precio']),
    'cantidad' => 1
  ];
}
$descuento = floatval($ticket['descuento'] ?? 0);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ticket Mesa #<?= $ticket['id'] ?></title>
  <style>
    body { font-family: monospace; font-size: 14px; padding: 10px; max-width: 300px; margin: auto; }
    h2 { text-align: center; }
    .linea { border-top: 1px dashed #000; margin: 8px 0; }
    .totales { margin-top: 10px; }
    .btns { margin-top: 20px; display: flex; justify-content: space-between; }
    @media print { .btns { display: none; } }
  </style>
</head>
<body>

<h2>🍽 Ticket Mesa</h2>
Mesa: <?= htmlspecialchars($ticket['mesa_id']) ?><br>
Fecha: <?= htmlspecialchars($ticket['fecha'] ?? date('Y-m-d')) ?><br>
Cliente: <?= htmlspecialchars($ticket['cliente'] ?: '-') ?><br>
Comentario: <?= htmlspecialchars($ticket['comentario'] ?: '-') ?>

<div class="linea"></div>

<b>Productos:</b><br>
<?php if (count($productos) > 0): ?>
  <ul>
    <?php foreach ($productos as $p): ?>
      <?php
        $nombre   = htmlspecialchars($p['nombre'] ?? 'Producto');
        $precio   = floatval($p['precio'] ?? 0);
        $cantidad = intval($p['cantidad'] ?? 1);
        $subtotal = $precio * $cantidad;
      ?>
      <li><?= $nombre ?> x<?= $cantidad ?> - $<?= number_format($subtotal, 2) ?></li>
    <?php endforeach; ?>
  </ul>
<?php else: ?>
  <i>Sin detalle</i><br>
<?php endif; ?>

<?php if ($descuento > 0): ?>
  <b>Descuento:</b> <?= number_format($descuento, 2) ?>%<br>
<?php endif; ?>

<div class="linea"></div>

<div class="totales">
  <b>Total:</b> $<?= number_format($ticket['total'], 2) ?><br>
  <b>Forma de pago:</b> <?= ucfirst($ticket['forma_pago']) ?><br>
  <?php if ($ticket['forma_pago'] === 'dividido'): ?>
    💵 Efectivo: $<?= number_format($ticket['efectivo'], 2) ?><br>
    💳 Transferencia: $<?= number_format($ticket['transferencia'], 2) ?><br>
  <?php endif; ?>
</div>

<div class="btns">
  <button onclick="window.print()">🖨 Imprimir</button>
  <a href="index.php">🔙 Volver</a>
</div>

<?php if ($autoPrint): ?>
<script>window.onload = () => window.print();</script>
<?php endif; ?>
</body>
</html>
