<?php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$id = intval($_GET['id'] ?? 0);
$autoPrint = isset($_GET['print']);

if ($id <= 0) {
  echo "❌ ID inválido.";
  exit;
}

$sql = "SELECT * FROM caja_sala WHERE id = $id LIMIT 1";
$res = mysqli_query($con, $sql);
if (!$res || mysqli_num_rows($res) == 0) {
  echo "❌ Ticket no encontrado.";
  exit;
}

$ticket = mysqli_fetch_assoc($res);
$detalles = json_decode($ticket['detalles_json'] ?? '{}', true);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ticket #<?= $ticket['id'] ?></title>
  <style>
    body {
      font-family: monospace;
      font-size: 13px;
      margin: 0;
      padding: 10px;
      background: white;
    }

    .ticket {
      width: 280px;
      max-width: 100%;
      margin: 0 auto;
    }

    .center {
      text-align: center;
    }

    .line {
      border-top: 1px dashed #000;
      margin: 8px 0;
    }

    .item {
      display: flex;
      justify-content: space-between;
    }

    .item span {
      white-space: nowrap;
    }

    .total {
      font-weight: bold;
      font-size: 14px;
    }

    @media print {
      body {
        background: none;
        margin: 0;
      }
    }
  </style>
</head>
<body<?= $autoPrint ? ' onload="window.print()"' : '' ?>>

<div class="ticket">
  <div class="center">
    <h3>🧾 TICKET</h3>
    <div>#<?= $ticket['id'] ?> - <?= $ticket['fecha'] ?> <?= substr($ticket['hora'], 0, 5) ?></div>
  </div>

  <div class="line"></div>

  <?php if ($ticket['cliente']): ?>
    <div><strong>Cliente:</strong> <?= htmlspecialchars($ticket['cliente']) ?></div>
  <?php endif; ?>

  <?php if ($ticket['comentario']): ?>
    <div><strong>Obs:</strong> <?= htmlspecialchars($ticket['comentario']) ?></div>
  <?php endif; ?>

  <?php if (!empty($detalles['hora_inicio'])): ?>
    <div><strong>Horario:</strong> <?= $detalles['hora_inicio'] ?> → <?= $detalles['hora_fin'] ?? '---' ?></div>
    <div><strong>Duración:</strong> <?= $detalles['duracion'] ?> min</div>
  <?php endif; ?>

  <div class="line"></div>

  <?php if (!empty($detalles['precio_sala'])): ?>
    <div class="item"><span>Sala</span><span>$<?= number_format($detalles['precio_sala'], 2, ',', '.') ?></span></div>
  <?php endif; ?>

  <?php if (!empty($detalles['productos'])): ?>
    <div><strong>Productos:</strong></div>
    <?php foreach ($detalles['productos'] as $p): ?>
      <div class="item"><span>- <?= $p['nombre'] ?></span><span>$<?= number_format($p['precio'], 2, ',', '.') ?></span></div>
    <?php endforeach; ?>
  <?php endif; ?>

  <?php if (!empty($detalles['alquileres'])): ?>
    <div><strong>Alquileres:</strong></div>
    <?php foreach ($detalles['alquileres'] as $a): ?>
      <div class="item"><span>- <?= $a['nombre'] ?></span><span>$<?= number_format($a['precio'], 2, ',', '.') ?></span></div>
    <?php endforeach; ?>
  <?php endif; ?>

  <?php if (!empty($detalles['descuento'])): ?>
    <div class="item"><span>Descuento</span><span>-<?= $detalles['descuento'] ?>%</span></div>
  <?php endif; ?>

  <div class="line"></div>
  <div class="item total"><span>Total</span><span>$<?= number_format($ticket['total'], 2, ',', '.') ?></span></div>

  <div class="line"></div>
  <div class="item"><span>Pago:</span><span><?= ucfirst($ticket['forma_pago']) ?></span></div>

  <?php if ($ticket['forma_pago'] === 'dividido'): ?>
    <div class="item"><span>Efectivo</span><span>$<?= number_format($ticket['efectivo'], 2, ',', '.') ?></span></div>
    <div class="item"><span>Transferencia</span><span>$<?= number_format($ticket['transferencia'], 2, ',', '.') ?></span></div>
  <?php endif; ?>

  <div class="center">
    <div class="line"></div>
    ¡Gracias por su visita!
  </div>
</div>

</body>
</html>
